<?php
/**
 * Description of Helpers
 *
 * @author eanaya
 */
class Helper {
    static function makeBreadCrumbs($breadCrumbs=array()) {
        $h = '<ul id="breadcrumbs">';
        $h .= '<li><a href="'.url_for('@homepage').'">Inicio</a></li>';
        foreach ($breadCrumbs as $bc) {
            if(isset($bc['link'])){
                $h .= '<li><a href="'.$bc['link'].'">'.$bc['text'].'</a></li>';
            }else{
                $h .= '<li>'.$bc['text'].'</li>';
            }
        }
        $h .= '</ul>';
        return $h;
    }

    static function swapDateFormat($date,$output_separator=''){
        $input_separators = array('/','-','.',' ');
        $search = true;
        $in_sep = $input_separators[0];
        foreach ($input_separators as $input_separator) {
            if($search && stripos($date,$input_separator)!==FALSE){
                $in_sep = $input_separator;
                $search = false;
            }
        }
        $output_separator = $output_separator == '' ? $in_sep : $output_separator;
        return implode($output_separator, array_reverse(explode($in_sep, $date)));
    }

    static function nf ($n){
        return number_format($n, 2,'.',' ');
    }

    static function m2h($mins) { 
        if ($mins < 0) { 
            $min = abs($mins); 
        } else { 
            $min = $mins; 
        } 
        $H = floor($min / 60); 
        $M = ($min - ($H * 60)) / 100; 
        $hours = $H +  $M; 
        if ($mins < 0) { 
            $hours = $hours * (-1); 
        } 
        $expl = explode(".", $hours); 
        $H = $expl[0]; 
        if (empty($expl[1])) { 
            $expl[1] = 00; 
        } 
        $M = $expl[1]; 
        if (strlen($M) < 2) { 
            $M = $M . 0; 
        } 
        return sprintf("%02d:%02d", $H, $M); 
    } 
    
}


?>
