<?php

/**
 * _tests actions.
 *
 * @package    sf_sandbox
 * @subpackage _tests
 * @author     Ernesto Anaya
 * @version    SVN: $Id: actions.class.php 23810 2009-11-12 11:07:44Z Kris.Wallsmith $
 */
class _testsActions extends sfActions {


    public function executeIndex(sfWebRequest $request) {
    }


    public function executeQ1(sfWebRequest $request) {
        $this->q1form = new Q1Form();
        if ($request->isMethod('post') && $request->getParameter('q1FormFields') ) {
            $this->q1form->bind($request->getParameter('q1FormFields'));
            if($this->q1form->isValid()) {
                $q1FormFields = $request->getParameter('q1FormFields');
                $viaje = $q1FormFields['trip'];
                $this->stretches = Doctrine::getTable('Trip')->find($viaje)->Stretches;
            }
        }
    }


    public function executeQ2(sfWebRequest $request) {

        $this->q2form = new Q2Form(array('fechas'=> array(
                                'from'=> array('year' => '2010','month' => '1','day' => '1'),
                                'to'=> array('year' => date('Y'),'month' => date('n'),'day' => date('d'))
                )));

        if ($request->isMethod('post') && $request->getParameter('q2FormFields') ) {
            $this->q2form->bind($request->getParameter('q2FormFields'));
            if($this->q2form->isValid()) {
                $q2FormFields = $request->getParameter('q2FormFields');
                $fecha_desde  = $q2FormFields['fechas']['from']['year']."-";
                $fecha_desde .= $q2FormFields['fechas']['from']['month']."-";
                $fecha_desde .= $q2FormFields['fechas']['from']['day'];
                $fecha_hasta  = $q2FormFields['fechas']['to']['year']."-";
                $fecha_hasta .= $q2FormFields['fechas']['to']['month']."-";
                $fecha_hasta .= $q2FormFields['fechas']['to']['day'];

                $this->Vehicles = Doctrine_Query::create()
                        ->from('Vehicle v')
                        ->leftJoin("v.Trips t")
                        ->leftJoin("t.Stretches s")
                        ->leftJoin("s.Route r")
                        ->leftJoin("r.Origin o")
                        ->leftJoin("r.Destiny d")
                        ->where('s.departure_time >= ?', $fecha_desde)
                        ->andWhere('s.departure_time <= ?', $fecha_hasta)
                        ->orWhere('s.arrival_time >= ?', $fecha_desde)
                        ->andWhere('s.arrival_time <= ?', $fecha_hasta)
                        ->fetchArray();
            }
        }
    }


    public function executeQ2cal(sfWebRequest $request) {
        $this->q2form = new Q2FormCal();

        if ($request->isMethod('post') && $request->getParameter('q2FormFields') ) {
            $this->q2form->bind($request->getParameter('q2FormFields'));
            if($this->q2form->isValid()) {
                $q2FormFields = $request->getParameter('q2FormFields');
                $fecha_desde  = $q2FormFields['from_date']['year']."-";
                $fecha_desde .= $q2FormFields['from_date']['month']."-";
                $fecha_desde .= $q2FormFields['from_date']['day'];
                $fecha_hasta  = $q2FormFields['to_date']['year']."-";
                $fecha_hasta .= $q2FormFields['to_date']['month']."-";
                $fecha_hasta .= $q2FormFields['to_date']['day'];

                $this->Vehicles = Doctrine_Query::create()
                        ->from('Vehicle v')
                        ->leftJoin("v.Trips t")
                        ->leftJoin("t.Stretches s")
                        ->leftJoin("s.Route r")
                        ->leftJoin("r.Origin o")
                        ->leftJoin("r.Destiny d")
                        ->where('s.departure_time >= ?', $fecha_desde)
                        ->andWhere('s.departure_time <= ?', $fecha_hasta)
                        ->orWhere('s.arrival_time >= ?', $fecha_desde)
                        ->andWhere('s.arrival_time <= ?', $fecha_hasta)
                        ->fetchArray();
            }
        }
    }


    public function executeQ3(sfWebRequest $request) {
        $this->q3form = new Q3Form(array('fechas'=> array(
                                'from'=> array('year' => '2010','month' => '1','day' => '1'),
                                'to'=> array('year' => date('Y'),'month' => date('n'),'day' => date('d'))
                )));
        if ($request->isMethod('post') && $request->getParameter('q3FormFields') ) {
            $this->q3form->bind($request->getParameter('q3FormFields'));
            if($this->q3form->isValid()) {
                $q3FormFields = $request->getParameter('q3FormFields');
                $fecha_desde  = $q3FormFields['fechas']['from']['year']."-";
                $fecha_desde .= $q3FormFields['fechas']['from']['month']."-";
                $fecha_desde .= $q3FormFields['fechas']['from']['day'];
                $fecha_hasta  = $q3FormFields['fechas']['to']['year']."-";
                $fecha_hasta .= $q3FormFields['fechas']['to']['month']."-";
                $fecha_hasta .= $q3FormFields['fechas']['to']['day'];
                $vehicle = $q3FormFields['vehicle'];

                $this->Trips = Doctrine_Query::create()
                        ->from('Trip t')
                        ->leftJoin("t.Stretches s")
                        ->leftJoin("t.Vehicle v")
                        ->where('v.id = ?', $vehicle)
                        ->andWhere(
                        '(s.departure_time >= ? AND '.
                        ' s.departure_time <= ? OR'.
                        ' s.arrival_time >= ? AND '.
                        ' s.arrival_time <= ? )',
                        array($fecha_desde ,$fecha_hasta, $fecha_desde ,$fecha_hasta)
                        )->fetchArray();
            }
        }
    }


    public function executeQ4(sfWebRequest $request) {
        $this->q4form = new Q4Form(array('fechas'=> array(
                                'from'=> array('year' => '2010','month' => '1','day' => '1'),
                                'to'=> array('year' => date('Y'),'month' => date('n'),'day' => date('d'))
                )));
        if ($request->isMethod('post') && $request->getParameter('q4FormFields') ) {
            $this->q4form->bind($request->getParameter('q4FormFields'));
            if($this->q4form->isValid()) {
                $q4FormFields = $request->getParameter('q4FormFields');
                $fecha_desde  = $q4FormFields['fechas']['from']['year']."-";
                $fecha_desde .= $q4FormFields['fechas']['from']['month']."-";
                $fecha_desde .= $q4FormFields['fechas']['from']['day'];
                $fecha_hasta  = $q4FormFields['fechas']['to']['year']."-";
                $fecha_hasta .= $q4FormFields['fechas']['to']['month']."-";
                $fecha_hasta .= $q4FormFields['fechas']['to']['day'];
                $route = $q4FormFields['route'];

                $this->Q4Trips = Doctrine_Query::create()
                        ->from('Trip t')
                        ->leftJoin("t.Vehicle v")
                        ->leftJoin("t.Stretches s")
                        ->leftJoin("s.Route r")
                        ->where('r.id = ?', $route)
                        ->andWhere(
                        '(s.departure_time >= ? AND '.
                        ' s.departure_time <= ? OR'.
                        ' s.arrival_time >= ? AND '.
                        ' s.arrival_time <= ? )',
                        array($fecha_desde ,$fecha_hasta, $fecha_desde ,$fecha_hasta)
                        )->fetchArray();
            }
        }
    }



    public function executeQ5(sfWebRequest $request) {
        $this->q5form = new Q5Form(array('fechas'=> array(
                                'from'=> array('year' => '2010','month' => '1','day' => '1'),
                                'to'=> array('year' => date('Y'),'month' => date('n'),'day' => date('d'))
                )));
        if ($request->isMethod('post') && $request->getParameter('q5FormFields') ) {
            $this->q5form->bind($request->getParameter('q5FormFields'));
            if($this->q5form->isValid()) {
                $q5FormFields = $request->getParameter('q5FormFields');
                $fecha_desde  = $q5FormFields['fechas']['from']['year']."-";
                $fecha_desde .= $q5FormFields['fechas']['from']['month']."-";
                $fecha_desde .= $q5FormFields['fechas']['from']['day'];
                $fecha_hasta  = $q5FormFields['fechas']['to']['year']."-";
                $fecha_hasta .= $q5FormFields['fechas']['to']['month']."-";
                $fecha_hasta .= $q5FormFields['fechas']['to']['day'];
                $vehicles = $q5FormFields['vehicles'];

                $this->Q5Stretches = Doctrine_Query::create()
                        ->from('Stretch s')
                        ->leftJoin("s.Trip t")
                        ->leftJoin("t.Vehicle v")
                        ->leftJoin("s.Route r")
                        ->leftJoin("r.Origin o")
                        ->leftJoin("r.Destiny d")
                        ->whereIn('v.id', $vehicles)
                        ->andWhere(
                        '(s.departure_time >= ? AND '.
                        ' s.departure_time <= ? OR'.
                        ' s.arrival_time >= ? AND '.
                        ' s.arrival_time <= ? )',
                        array($fecha_desde ,$fecha_hasta, $fecha_desde ,$fecha_hasta)
                        )->fetchArray();
            }
        }
    }


}