<?php
class Q2Form extends BaseForm{

    public function configure(){

        $this->setWidgets(array(
            'fechas'=> new sfWidgetFormDateRange(array(
                'from_date' => new sfWidgetFormDate(),
                'to_date' => new sfWidgetFormDate()
            ))
        ));

        $this->setValidators(array(
            'fechas'    => new sfValidatorDateRange(array(
                'from_date'   => new sfValidatorDate(),
                'to_date' => new sfValidatorDate()
            ))
        ));

        $this->widgetSchema->setNameFormat('q2FormFields[%s]');

        $this->validatorSchema->setPostValidator(
            new sfValidatorSchemaCompare(
                'from_date',
                sfValidatorSchemaCompare::LESS_THAN_EQUAL,
                'to_date',
                array('throw_global_error' => true),
                array('invalid' => 'The start date ("%left_field%") must be before the end date ("%right_field%")')
            )
        );

    }

}
?>