<?php
class Q4Form extends BaseForm{

    protected static $routes;

    public function configure(){

        self::$routes[''] = "--- Seleccione la Ruta ---";
        foreach (Doctrine::getTable('Route')->findAll() as $route ){
            self::$routes[$route->id] = $route->Origin->name." => ".$route->Destiny->name." (".$route->distance.")";
        }


        $this->setWidgets(array(
            'route' => new sfWidgetFormSelect(array('choices' =>self::$routes )),
            'fechas'=> new sfWidgetFormDateRange(array(
                'from_date' => new sfWidgetFormDate(),
                'to_date' => new sfWidgetFormDate()
            ))
        ));

        $validRoutes = array_keys(array_slice(self::$routes,1,count(self::$routes)-1,true));
        $this->setValidators(array(
            'route' => new sfValidatorChoice(
                array( 'choices' => $validRoutes ),
                array('required' => 'Debes seleccionar una Ruta','invalid' => 'Ruta no válido')
            ),
            'fechas'    => new sfValidatorDateRange(array(
                'from_date'   => new sfValidatorDate(),
                'to_date' => new sfValidatorDate()
            ))
        ));

        $this->widgetSchema->setNameFormat('q4FormFields[%s]');

        $this->validatorSchema->setPostValidator(
            new sfValidatorSchemaCompare(
                'from_date',
                sfValidatorSchemaCompare::LESS_THAN_EQUAL,
                'to_date',
                array('throw_global_error' => true),
                array('invalid' => 'The start date ("%left_field%") must be before the end date ("%right_field%")')
            )
        );

    }

}
?>