<?php
class Q5Form extends BaseForm{

    protected static $vehicles;

    public function configure(){

        foreach (Doctrine::getTable('Vehicle')->findAll() as $vehicle ){
            self::$vehicles[$vehicle->id] = $vehicle->plate." ".$vehicle->model." (".$vehicle->Company->name.")";
        }


        $this->setWidgets(array(
            'vehicles' => new sfWidgetFormSelect(array('choices' => self::$vehicles, 'multiple'=>true )),
            'fechas'=> new sfWidgetFormDateRange(array(
                'from_date' => new sfWidgetFormDate(),
                'to_date' => new sfWidgetFormDate()
            ))
        ));

        $this->setValidators(array(
            'vehicles' => new sfValidatorChoice(
                array( 'choices' => array_keys(self::$vehicles), 'multiple'=>true ),
                array('required' => 'Debes seleccionar al menos un vehívulo' ,'invalid' => 'Vehículo no válido')
            ),
            'fechas'    => new sfValidatorDateRange(array(
                'from_date'   => new sfValidatorDate(),
                'to_date' => new sfValidatorDate()
            ))
        ));

        $this->widgetSchema->setNameFormat('q5FormFields[%s]');

        $this->validatorSchema->setPostValidator(
            new sfValidatorSchemaCompare(
                'from_date',
                sfValidatorSchemaCompare::LESS_THAN_EQUAL,
                'to_date',
                array('throw_global_error' => true),
                array('invalid' => 'The start date ("%left_field%") must be before the end date ("%right_field%")')
            )
        );

    }

}
?>