<?php

/**
 * control_tower actions.
 *
 * @package    sf_sandbox
 * @subpackage control_tower
 * @author     Your name here
 * @version    SVN: $Id: actions.class.php 23810 2009-11-12 11:07:44Z Kris.Wallsmith $
 */
class control_towerActions extends sfActions {
    /**
     * Executes index action
     *
     * @param sfRequest $request A request object
     */
    public function executeIndex(sfWebRequest $request) {
        $this->userName = $this->getUser()->getUsername();
        $this->date = $request->getParameter("day") != "" ?
                $request->getParameter("day") . '/'.
                $request->getParameter("month") . '/'.
                $request->getParameter("year") :
                date("d/m/Y");


        // get the list of flights 
        $flights = Doctrine::getTable('Trip')
          ->createQuery('v')
          ->where("departure_date= str_to_date(?, '%d/%m/%Y')", $this->date)
          ->andWhere('canceled = ?',false)
          ->addOrderBy('vehicle_id')
          ->execute();
        $this->flights = $flights;
        // since we have 1 formset per trip, we need an array of formsets
        $this->formsets = array();
        // create a formset for each flight
        foreach ($flights as $flight) {
            $this->formsets[$flight->id] =
            new StretchFormSet("stretches", $flight);
        }	
        // bind and save the stretches
        if ($request->isMethod('post')) {
            foreach ($this->formsets as $formset) {
                 $formset->bind($request);
                 if ($formset->is_valid()) {
                     $formset->save();
	         }
	    }
	}

        if($request->getParameter('summary')){
            $this->summary = true;
        }else {
            $this->summary = false;
        }


    }
}
