<?php

/**
 * Stretch formset.
 *
 * @package    sf_sandbox
 * @subpackage form
 * @author     Your name here
 * @version    SVN: $Id: sfDoctrineFormTemplate.php 23810 2009-11-12 11:07:44Z Kris.Wallsmith $
 */
class CustomStretchForm extends StretchForm {
  
  /*
   * Changes the current form name
   * @name: the new name for the form
   */  
  public function set_name($name) {
    $this->widgetSchema->setNameFormat($name.'[%s]');
  }

  /*
   * Initialization function
   */  
  public function configure() {

    // created_at and updated_at are not filled by the user
    unset($this['created_at'], $this['updated_at']); 
    
    // this fields are text fields (defaults are comboboxes)
    $this->widgetSchema['engine_start_time'] = new sfWidgetFormInputText();
    $this->widgetSchema['takeoff_time'] = new sfWidgetFormInputText();
    $this->widgetSchema['departure_time'] = new sfWidgetFormInputText();
    $this->widgetSchema['arrival_time'] = new sfWidgetFormInputText();
    $this->widgetSchema['landing_time'] = new sfWidgetFormInputText();
    $this->widgetSchema['engine_stop_time'] = new sfWidgetFormInputText();
    
    // hide the prefilled trip and route
    $this->widgetSchema['trip_id'] = new sfWidgetFormInputHidden();
    $this->widgetSchema['origin_id'] = new sfWidgetFormInputHidden();
    $this->widgetSchema['destination_id'] = new sfWidgetFormInputHidden();

    // our design uses the attribute class=hora in the html to render this
    // widgets
    $this->widgetSchema['engine_start_time']->setAttribute('class', 'hora');
    $this->widgetSchema['takeoff_time']->setAttribute('class', 'hora');
    $this->widgetSchema['departure_time']->setAttribute('class', 'hora');
    $this->widgetSchema['arrival_time']->setAttribute('class', 'hora');
    $this->widgetSchema['landing_time']->setAttribute('class', 'hora');
    $this->widgetSchema['engine_stop_time']->setAttribute('class', 'hora');
    $this->disableLocalCSRFProtection();
    
  }

}

