<?php

/**
 * fuel actions.
 *
 * @package    plm
 * @subpackage fuel
 * @author     Antonio Ognio <aognio@aureal.com.pe>
 * @version    SVN: $Id: actions.class.php 23810 2009-11-12 11:07:44Z Kris.Wallsmith $
 */
class fuelActions extends sfActions {
  
  /*
   * Lists and filters trips for a given date, by default today.
   *
   * @param sfRequest $request A request object
   */
  public function executeIndex(sfWebRequest $request) {
    $this->userName = $this->getUser()->getUsername();
    /* Builds the date from parameters in the URL */
    $this->day = $request->getParameter('day');
    $this->month = $request->getParameter('month');
    $this->year = $request->getParameter('year');       

    /* Checks that all three parameters have values and sets the date from 
       them */
    /* No validation is need since the URL parser is using a regexp for 
       the match */
    if (strlen($this->day)>0 && strlen($this->month)>0 && 
        strlen($this->year)>0) {
        $this->date = sprintf("%02d/%02d/%02d", $this->day, $this->month, 
                                                            $this->year);
    } 
    else {
      if ($request->getParameter('date') != "") {
        $this->date = $request->getParameter('date');
      }
      else {
        /* If any of the parameters is missing use the current date */
        $this->date = date("d/m/Y");
      }
    }

    /* Retrieve all the trips for the given date */
    $this->trips = Doctrine::getTable('Trip')
        ->createQuery('v')
        ->where("departure_date = ?", Helper::swapDateFormat($this->date))
        ->addOrderBy('vehicle_id')
        ->execute();
  }

  /**
   * In this action the logistic assistant will fill out the fuel comsumption
   * for all stretches in the given trip
   * 
   * On post, data gets saved and the forms with the data for the same date ge
   */
  function executeDetail(sfWebRequest $request) {
      $this->userName = $this->getUser()->getUsername();
      $this->id = $request->getParameter('id');
      // build the date
      $this->day = $request->getParameter('day');
      $this->month = $request->getParameter('month');
      $this->year = $request->getParameter('year');       
      
      $this->date = sprintf("%02d/%02d/%02d", $this->day, $this->month, 
                                                          $this->year);
    $this->vehicle = Doctrine::getTable('Vehicle')->find($this->id);
      $this->trips = Doctrine::getTable('Trip')
        ->createQuery('t')
        ->where("departure_date = ?", Helper::swapDateFormat($this->date))
        ->andWhere("vehicle_id = ?", $this->id)
        ->addOrderBy('vehicle_id')
        ->execute();

      $this->form_set = new FuelRecordFormSet("fuel_record", $this->trips);
      if ($request->isMethod('post')) {
          $this->form_set->bind($request);
          if ($this->form_set->is_valid()) { 
            $this->form_set->save();
            $route = '@fuel_for_vehicle?';
            $route .= 'id='.$this->id.'&';
            $route .= 'day='.$this->day.'&';
            $route .= 'month='.$this->month.'&';
            $route .= 'year='.$this->year;
            
            $this->redirect($route);
          } 
      }
  }
}
