<?php

/**
 * FuelRecord formset.
 *
 * @package    sf_sandbox
 * @subpackage form
 * @author     Antonio Ognio <aognio@aureal.com.pe> 
 * @version    SVN: $Id: sfDoctrineFormTemplate.php 23810 2009-11-12 11:07:44Z Kris.Wallsmith $
 */
class FuelRecordFormSet {

  var $name;
  var $forms;
  var $trips;
  /*
   * Contructs and configures a form set for handling fuel consumption for vehicles
   * in a given date.
   *
   * @formset_name: name (prefix) for the formset
   */
  function __construct($formset_name, $trips) {
    $this->name = $formset_name;
    $this->forms = array();
    $this->trips = $trips;

    /* create the form objects */
    foreach ($trips as $trip){
        foreach ($trip->Stretches as $s) {
          /* For each stretch, get the fuel related information from the 
           * database and use it int eh formset       
           */
          $name = sprintf("%s_form_fuel_%d", $this->name, $s->id);
          /* Adds form object to form set */
          $this->forms[$trip->id][$s->id] = new FuelRecordForm($s);
          /* Sets name for the form */
          $this->forms[$trip->id][$s->id]->set_name($name);
        }
    }
  }

  /*
   * Fills the formset with data from the request
   * @request: the WebRequest object provided by Symfony
   */  
  public function bind(sfWebRequest $request) {
    foreach ($this->trips as $trip) {
        if(isset( $this->forms[$trip->id] )){ //TODO: mejorar este parche
            foreach ($this->forms[$trip->id] as $form) {
                $form->bind($request->getParameter($form->getName()),
                    $request->getFiles($form->getName()));
            }
        }
    }
  }

  /* Sets name for the form
   * Validates every form in the set
   */
  function is_valid() {
    // validates every form in the set
    $all_valids = true;
    foreach ($this->trips as $trip) {
        if(isset($this->forms[$trip->id])){ //TODO: mejorar este parche
            foreach ($this->forms[$trip->id] as $form) {
              if (!$form->isValid()) {
                  $all_valids =  false;
              }
            }
        }
    }
    return $all_valids;
  }
  
  /*
   * Saves every form in the formset
   */
  function save() {
    foreach ($this->trips as $trip) {
        if(isset($this->forms[$trip->id])){ //TODO: mejorar este parche
            foreach ($this->forms[$trip->id] as $form) {
            $form->save();
            }
        }
    }
  }
  
}
