<?php
/**
 * manifest actions.
 *
 * @package    sf_sandbox
 * @subpackage manifest
 * @author     Your name here
 * @version    SVN: $Id: actions.class.php 23810 2009-11-12 11:07:44Z Kris.Wallsmith $
 */
class manifestActions extends sfActions {
    /**
     * Executes index action
     *
     * @param sfRequest $request A request object
     */
    public function executeIndex(sfWebRequest $request) {
        $this->userName = $this->getUser()->getUsername();
        //get all the flights
        $this->search_form = new ManifestSearchForm();
        $this->search_form->bind($request->getParameter(
                $this->search_form->getName()));

        // first use the form date
        if ($this->search_form->getValue('date') != "" ) {
            $this->date = $this->search_form->getValue('date');
        }
        // next try with the url date
        elseif ($request->getParameter("day") != "") {
            $this->date = $request->getParameter("day") . '/'.
                    $request->getParameter("month") . '/'.
                    $request->getParameter("year");
        }
        // finally use the current working date from the session
        else {
            $this->date = $this->getUser()->getAttribute('current_working_date', date('d/m/Y'));
        }

        // Set current working date in the session
        $this->getUser()->setAttribute('current_working_date', $this->date);

        // if a vehicle is provided use it
        $vehicle_id = $this->search_form->getValue('vehicle_id');
        $category = $this->search_form->getValue('category');
        $this->vehicle = '';
        $flights = Doctrine_Query::create()
                ->from('Trip t')
                ->leftJoin("t.Vehicle v")
                ->where("t.departure_date = str_to_date(?, '%d/%m/%Y')", $this->date);
        if (strlen($vehicle_id)>0) {
            $flights = $flights->andWhere('v.id = ?', $vehicle_id);
        }
        else {
            $flights = Doctrine::getTable('Trip')
                    ->createQuery('v')
                    ->where("departure_date = str_to_date(?, '%d/%m/%Y')", $this->date);
        }

        // recreate and re fill the form with the selected data
        $this->search_form = new ManifestSearchForm();
        $this->search_form->setDefault('date', $this->date);
        $this->search_form->setDefault('vehicle_id', $vehicle_id);

        $this->date_obj = mktime(0,0,0, substr($this->date, 3, 2),
                substr($this->date, 0, 2),
                substr($this->date, 6, 4));

        if (strlen($category)>0) {
            $flights = $flights->andWhere('v.category = ?', $category);
        }

        $this->flights = $flights->execute();

        $this->vehicle = Doctrine::getTable('Vehicle')->find($vehicle_id);

        // recreate and re fill the form with the selected data
        $this->search_form = new ManifestSearchForm();
        $this->search_form->setDefault('date', $this->date);
        $this->search_form->setDefault('vehicle_id', $vehicle_id);
        $this->search_form->setDefault('category', $category);

        $this->date_obj = mktime(0,0,0, substr($this->date, 3, 2),
                substr($this->date, 0, 2),
                substr($this->date, 6, 4));
    }

    /*
   * Detail action, provides the formsets to insert manifest details
   * @param sfRequest $request A request object
    */
    public function executeDetail(sfWebRequest $request) {
        $this->userName = $this->getUser()->getUsername();
        // get the flight and its date
        $this->id = $request->getParameter('id');
        $this->flight = Doctrine::getTable('Trip')->find($this->id);
        $this->date_obj =   $this->flight->getDateTimeObject('departure_date')
                ->format('U');
        $this->date =   $this->flight->departure_date;
        // prepare the empty formsets
        // if the user entered more forms using javascript the number of forms
        // is in the parameter *_max_forms
        $this->crew_form_set = new CrewFormSet($this->flight,
                $request->getParameter("crew_max_forms") ?
                $request->getParameter("crew_max_forms") : 5,
                "crew");
        $this->cargo_form_set = new CargoFormSet($this->flight,
                $request->getParameter("cargo_max_forms") ?
                $request->getParameter("cargo_max_forms") : 5,
                "cargo");
        $this->passenger_form_set = new PassengerFormSet($this->flight,
                $request->getParameter("passengers_max_forms") ?
                $request->getParameter("passengers_max_forms") : 5,
                "passenger");
        // if data is provided via the post method, save the formsets
        if ($request->isMethod('post')) {
            // fill the forms
            $this->crew_form_set->bind($request);
            $this->cargo_form_set->bind($request);
            $this->passenger_form_set->bind($request);
            // just save the formsets if all of them are valid
            // rememeber we need to call is_valid for every formset, so we cant
            // do this in the if clause
            $v1 = $this->crew_form_set->is_valid();
            $v2 = $this->cargo_form_set->is_valid();
            $v3 = $this->passenger_form_set->is_valid();
            if ($v1 and $v2 and $v3) {
                $this->crew_form_set->save();
                $this->passenger_form_set->save();
                $this->cargo_form_set->save();

                // calling function to pre-calculate time and costs data for each manifest detail
                $this->flight->updatePrecalculatedFields();

                // redirect to the trip index
                //$this->redirect('manifest/index');
                $this->redirect(
                        '@manifests_for_date?day='.
                        $this->flight->getDateTimeObject('departure_date')->format('d').
                        '&month='.
                        $this->flight->getDateTimeObject('departure_date')->format('m').
                        '&year='.
                        $this->flight->getDateTimeObject('departure_date')->format('Y')
                );
            }
        }

    }

    /*
   * Provides an autocomplete suggestion for a given name or document number as a vector
   * separated by pipes.
    */
    public function executeAutocomplete(sfWebRequest $request) {
        $q = $request->getParameter('q');
        $data = Doctrine_Query::create()
                ->select("doc_number as document, doc_type as document_type, concat(last_name,concat(', ', firstname)) as name, company_id as company, weight, cost_center_id as cost_center")
                ->from('Person')
                ->where("doc_number like '%$q%'")
                ->orWhere("firstname like '%$q%'")
                ->orWhere("last_name like '%$q%'")
                ->fetchArray();
        $result = "";
        foreach ($data as $row) {
            $result .= $row['document']."|".$row['document_type']."|".$row['name']."|".$row['weight']."|".$row['company']."|".$row['cost_center']."\n";
        }
        $this->getResponse()->setHttpHeader('Content-type', 'text/plain');
        return $this->renderText($result);
    }

    public function executePrueba3(sfWebRequest $request) {
        $v = Doctrine::getTable('Vehicle')->findOneById(5);
        var_dump($v->getMonthBillableTime());
        exit;
    }

}
