<?php
/*
  Class used to dinamically generate Crewforms for manifest details
 */
class CrewFormSet {
  var $flight;
  var $max_forms;
  var $forms;
  var $form_count;
  /*
    Default contructor
    @flight: flight related to he manifest detail
    @max_forms: maximum ammount of forms used with out considering the 
        details in the database
    @name: the name for the forms

   */
  public function __construct($flight, $max_forms, $name) {
     $this->flight = $flight;
     $this->max_forms = $max_forms;
     // prefill the first forms with data from the database
     $saved_crew = count($this->flight->CrewpersonManifestDetails);
     
     for ($i = 0; $i < $saved_crew ; $i++) {
       $this->forms[$i] = new CustomCrewpersonManifestDetailForm();
       $this->forms[$i]->bind_object(
				 $this->flight->CrewpersonManifestDetails[$i]);
       $this->forms[$i]->set_name($name."_formset#".$i);
       
     }

     if ($saved_crew > $max_forms){
       $max_forms = $saved_crew + 5;
     }

     // append empty forms
     for ($i = $saved_crew; $i < $max_forms ; $i++) {
       $this->forms[$i] = new CustomCrewpersonManifestDetailForm();
       $this->forms[$i]->set_name($name."_formset#".$i);
       $this->forms[$i]->unset_delete_check();
       $this->forms[$i]->setDefault('trip_id', $flight->id);
     }
     $this->form_count = $max_forms;
   }
  
  /*
   * Fills the formset with data from the request
   * @request: the WebRequest object provided by Symfony
   */  
  function bind(sfWebRequest $request) {
    // bind every form in the set
    foreach ($this->forms as $form) {
      $form->bind($request->getParameter($form->getName()),
		  $request->getFiles($form->getName()));
    }
  }

  /*
   * Validates every form in the set
   */
  function is_valid() {
    $has_errors = false;
    foreach ($this->forms as $form) {
      // if the form is not valid and not filled this is not an error
      if(!$form->isValid()) {
	if (!$form->isFilled()) {
	// the form is empty so clean the errors and fields
	$form->clear();
	}
	else {
	  $has_errors = true;
	}
      }
    }
    return !$has_errors;
  }

  /*
   * saves every form in the set
   */
  public function save() {
    foreach ($this->forms as $form) {
      $form->save();
    }
  }


  
}
?>