<?php
/*
  Class used to dinamically generate Passengerforms for manifest details
*/
class PassengerFormSet {
    var $flight;
    var $max_forms;
    var $forms;
    var $form_count;
    /*
    Default contructor
    @flight: flight related to he manifest detail
    @max_forms: maximum ammount of forms used with out considering the 
        details in the database
    @name: the name for the forms

    */
    public function __construct($flight, $max_forms, $name) {
        $this->flight = $flight;
        $this->max_forms = $max_forms;
        // prefill the first forms with data from the database
        $passengers = Doctrine_Query::create()
                ->select('p.*')
                ->from('PassengerManifestDetail p')
                ->leftJoin('p.Origin o')
                ->where('o.trip_id = ?', $flight->id)
                ->execute();
        $saved_passengers = count($passengers);
        // prepare pre filled forms
        $i = 0;
        foreach ($passengers as $passenger) {
            $this->forms[$i] = new CustomPassengerManifestDetailForm(
                    array('trip'=>$flight));
            $this->forms[$i]->bind_object($passenger);
            $this->forms[$i]->set_name($name."_formset#".$i);
            $i++;
        }
     if ($saved_passengers > $max_forms){
            $max_forms = $saved_passengers + 5;
        }
        // append empty forms
        for ($i = $saved_passengers; $i < $max_forms ; $i++) {
            $this->forms[$i] = new CustomPassengerManifestDetailForm(
                    array('trip'=>$flight));
            $this->forms[$i]->set_name($name."_formset#".$i);
            $this->forms[$i]->unset_delete_check();
        }
        $this->form_count = $max_forms;
    }

    /*
   * Fills the formset with data from the request
   * @request: the WebRequest object provided by Symfony
    */
    function bind(sfWebRequest $request) {
        // bind every form in the set
        foreach ($this->forms as $form) {
            $form->bind($request->getParameter($form->getName()),
                    $request->getFiles($form->getName()));
        }
    }

    /*
   * Validates every form in the set
    */
    function is_valid() {
        $has_errors = false;
        foreach ($this->forms as $form) {
            // if the form is not valid and not filled this is not an error
            if(!$form->isValid()) {
                if (!$form->isFilled()) {
                    // the form is empty so clean the errors and fields
                    $form->clear();
                }
                else {
                    $has_errors = true;
                }
            }
        }
        return !$has_errors;
    }

    /*
   * saves every form in the set
    */
    public function save() {
        foreach ($this->forms as $form) {
            $form->save();
        }
    }



}
?>