<!-- datePicker -->
<?php use_javascript('ui.core.js') ?>
<?php use_javascript('ui.datepicker.js') ?>
<?php use_stylesheet('ui-lightness/jquery-ui-1.8rc1.custom.css') ?>

<?php use_javascript('manifest.js') ?>
<?php use_stylesheet('manifest.css') ?>
<?php use_stylesheet('flight.css') ?>


<?php slot('userName',$userName); ?>
<?php slot('breadCrumbs',Helper::makeBreadCrumbs(array(
    array('link' => url_for('@fligths'), 'text' => 'Viajes'),
    array('link' => url_for('@manifests'), 'text' => 'Manifiestos'),
    array('text' => date('d/m/Y', $date_obj))
))); ?>


<div id="main">
    <h2>Manifiestos</h2>

    <form method="get" action=".">
        <ul class="horizontal_form clear">
            <li>
                <label for="date">Seleccionar fecha:</label><br />
		<?php echo $search_form['date']; ?>
	    </li>
            <li>
                <label for="vehicle">Vehículo:</label><br />
		<?php echo $search_form['vehicle_id']; ?>
            </li>
            <li>
                <label for="vehicle"><?php echo $search_form['category']->renderLabel(); ?></label><br />
		<?php echo $search_form['category']; ?>
            </li>
            <li>
                <br />
                <input type="submit" value="Filtrar" />
            </li>
        </ul>
    </form>

<?php if ($flights->count()>0) { ?>
    <h3>Viajes para <?= $date ?></h3>
    <?php if ($vehicle){ ?>
    <h4><?php echo $vehicle; ?></h4>
    <?php } ?>

    <?php $vehicles_with_title = array(); ?>
    <?php foreach ($flights as $flight) { ?>
    <?php if (!in_array($flight->getVehicleId(), $vehicles_with_title)) { ?>
    <?php   $vehicles_with_title[] = $flight->getVehicleId(); ?>
    <h4><?php echo $flight->getVehicle(); ?></h4>
    <?php } ?>
    <table class="data" border="0" cellspacing="0" cellpadding="0">
        <caption><?php echo link_to(sprintf("Vuelo #%d: %s", $flight->id, $flight->description), '@manifest_detail?id='.$flight->id); ?></caption>
        <tr>
            <th>#</th>
            <th>Origen</th>
            <th>Destino</th>
            <th>Inicio</th>
            <th>Llegada</th>
        </tr>
	  <?php $stretch_count = 1; ?>
	  <?php foreach ($flight->Stretches as $stretch){ ?>
            <tr class="<?php if ($stretch_count%2==0) echo 'odd'; ?>" >
                <td><?php echo $stretch_count; ?></td>
                <td><?php echo $stretch->Origin;?></td>
                <td><?php echo $stretch->Destination;?></td>
                <td><?= $stretch->departure_time; ?></td>
                <td><?= $stretch->arrival_time; ?></td>
	     <?php $stretch_count++; ?>
            </tr>
	    <?php } ?>
        </tbody>
    </table>
    <?php } // end of foreach for trips ?>
<?php } else { ?>
<?php if ($vehicle) { ?>
<p class="info">No hay vuelos para este vehículo en la fecha seleccionada.</p>
<?php } else { ?>
<p class="info">No hay vuelos que cumplan con los criterios seleccionados.</p>
<?php } ?>
<?php } ?>
</div>
