<!-- JS deps -->
<?php use_javascript('ui.js') ?>

<!-- datePicker -->
<?php use_javascript('ui.datepicker.js') ?>
<?php use_stylesheet('ui-lightness/jquery-ui-1.8rc1.custom.css') ?>

<!-- timePicker -->
<?php use_stylesheet('ui.timepickr.css') ?>
<?php use_javascript('jquery.utils.js') ?>
<?php use_javascript('jquery.strings.js') ?>
<?php use_javascript('ui.dropslide.js') ?>
<?php use_javascript('ui.timepickr-0.3.js') ?>

<!-- local -->
<?php use_stylesheet('people_location.css'); ?>
<?php use_javascript('people_location.js'); ?>

<?php include_stylesheets_for_form($searchTareoForm) ?>
<?php include_javascripts_for_form($searchTareoForm) ?>

<?php include_stylesheets_for_form($tareoForm) ?>
<?php include_javascripts_for_form($tareoForm) ?>

<?php slot('userName',$userName); ?>
<?php slot('breadCrumbs',Helper::makeBreadCrumbs(array(
    array('text' => 'Tareo')
))); ?>


<div id="main">
    
    <div id="searchFormDiv">
        <h2>Búsqueda en Tareo</h2>
        <?php if(0){ ?>
            <p id="notice">Esta búsqueda no devuelve resultados.</p>
        <?php } ?>
        <form action="<?=url_for('people_location/search')?>" id="searchForm" method="GET">
            <?=$searchTareoForm->renderHiddenFields()?>
            <ul class="divided vertical_form">
                <?php if($searchTareoForm->hasGlobalErrors()) { ?>
                    <li><?=$searchTareoForm->renderGlobalErrors()?></li>
                <?php } ?>
                <li>
                    <?=$searchTareoForm['Date']->renderLabel()?><br />
                    <?=$searchTareoForm['Date']->renderHelp()?>
                    <?=$searchTareoForm['Date']->render()?>
                    <?=$searchTareoForm['Date']->renderError()?>
                </li>
                <li>
                    <?=$searchTareoForm['Company']->renderLabel()?><br />
                    <?=$searchTareoForm['Company']->renderHelp()?>
                    <?=$searchTareoForm['Company']->render()?>
                    <?=$searchTareoForm['Company']->renderError()?>
                </li>
                <li>
                    <?=$searchTareoForm['Job']->renderLabel()?><br />
                    <?=$searchTareoForm['Job']->renderHelp()?>
                    <?=$searchTareoForm['Job']->render()?>
                    <?=$searchTareoForm['Job']->renderError()?>
                </li>
                <li>
                    <?=$searchTareoForm['Location']->renderLabel()?><br />
                    <?=$searchTareoForm['Location']->renderHelp()?>
                    <?=$searchTareoForm['Location']->render()?>
                    <?=$searchTareoForm['Location']->renderError()?>
                </li>
                <li>
                    <br /><input type="submit" value="Buscar" />
                </li>
            </ul>
        </form>
    </div>

    <div id="tareoFormDiv">
        <h2>Registrar en Tareo</h2>
        <?php if(0){ ?>
            <p id="notice">El usuario ha sido creado satisfactoriamente.</p>
        <?php } ?>
        <form action="<?=url_for('people_location/create')?>" id="tareoForm" method="POST">
            <?=$tareoForm->renderHiddenFields()?>
            <?php if($tareoForm->hasGlobalErrors()) { ?>
                <div class="global_errors"><?=$tareoForm->renderGlobalErrors()?></div>
            <?php } ?>
            <ul class="divided vertical_form" id="tareoForm_col1">
                <li>
                    <?=$tareoForm['doc_type']->renderLabel()?><br />
                    <?=$tareoForm['doc_type']->renderHelp()?>
                    <?=$tareoForm['doc_type']->render()?>
                    <?=$tareoForm['doc_type']->renderError()?>
                </li>
                <li>
                    <?=$tareoForm['doc_number']->renderLabel()?><br />
                    <?=$tareoForm['doc_number']->renderHelp()?>
                    <?=$tareoForm['doc_number']->render()?>
                    <?=$tareoForm['doc_number']->renderError()?>
                </li>
                <li>
                    <?=$tareoForm['firstname']->renderLabel()?><br />
                    <?=$tareoForm['firstname']->renderHelp()?>
                    <?=$tareoForm['firstname']->render()?>
                    <?=$tareoForm['firstname']->renderError()?>
                </li>
                <li>
                    <?=$tareoForm['last_name']->renderLabel()?><br />
                    <?=$tareoForm['last_name']->renderHelp()?>
                    <?=$tareoForm['last_name']->render()?>
                    <?=$tareoForm['last_name']->renderError()?>
                </li>
                <li>
                    <?=$tareoForm['location_id']->renderLabel()?><br />
                    <?=$tareoForm['location_id']->renderHelp()?>
                    <?=$tareoForm['location_id']->render()?>
                    <?=$tareoForm['location_id']->renderError()?>
                </li>
            </ul>
            <ul class="divided vertical_form" id="tareoForm_col2">
                <li>
                    <div id="arrival_date">
                        <?=$tareoForm['arrival_date']->renderLabel()?><br />
                        <?=$tareoForm['arrival_date']->renderHelp()?>
                        <?=$tareoForm['arrival_date']->render()?>
                        <?=$tareoForm['arrival_date']->renderError()?>
                    </div>
                    <div id="arrival_time">
                        <?=$tareoForm['arrival_time']->renderLabel()?><br />
                        <?=$tareoForm['arrival_time']->renderHelp()?>
                        <?=$tareoForm['arrival_time']->render()?>
                        <img border="0" id="trigger-arrival" alt="Time" src="/images/clock.png">
                        <?=$tareoForm['arrival_time']->renderError()?>
                    </div>
                    <div class="clear"></div>
                </li>
                <li>
                    <div id="departure_date">
                        <?=$tareoForm['departure_date']->renderLabel()?><br />
                        <?=$tareoForm['departure_date']->renderHelp()?>
                        <?=$tareoForm['departure_date']->render()?>
                        <?=$tareoForm['departure_date']->renderError()?>
                    </div>
                    <div id="departure_time">
                        <?=$tareoForm['departure_time']->renderLabel()?><br />
                        <?=$tareoForm['departure_time']->renderHelp()?>
                        <?=$tareoForm['departure_time']->render()?>
                        <img border="0" id="trigger-departure" alt="Time" src="/images/clock.png">
                        <?=$tareoForm['departure_time']->renderError()?>
                    </div>
                    <div class="clear"></div>
                </li>
                <li>
                    <?=$tareoForm['company_id']->renderLabel()?><br />
                    <?=$tareoForm['company_id']->renderHelp()?>
                    <?=$tareoForm['company_id']->render()?>
                    <?=$tareoForm['company_id']->renderError()?>
                </li>
                <li>
                    <?=$tareoForm['job_id']->renderLabel()?><br />
                    <?=$tareoForm['job_id']->renderHelp()?>
                    <?=$tareoForm['job_id']->render()?>
                    <?=$tareoForm['job_id']->renderError()?>
                </li>
                <li>
                    <br /><input type="submit" value="Registrar" />
                </li>
            </ul>
        </form>
    </div>

    <div class="clear"></div>

    <?php if (isset($tareoItems)) {?>
        <table border="0" class="data">
            <thead>
                <tr>
                    <th>Tipo Documento</th>
                    <th>N° de Documento</th>
                    <th>Nombres</th>
                    <th>Apellidos</th>
                    <th>Fecha de Entrada</th>
                    <th>Fecha de Salida</th>
                    <th>Empresa</th>
                    <th>Puesto</th>
                    <th>Ubicación</th>
                </tr>
            </thead>
            <tbody>
                <?php $i=0; foreach($tareoItems as $tareoItem){ ?>
                    <tr class="<?=$i%2==0?'odd':'even'?>">
                        <td><?php echo $tareoItem['doc_type']; ?></td>
                        <td><?php echo $tareoItem['doc_number']; ?></td>
                        <td><?php echo $tareoItem['firstname']; ?></td>
                        <td><?php echo $tareoItem['last_name']; ?></td>
                        <td><?php echo $tareoItem['arrival']; ?></td>
                        <td><?php echo $tareoItem['departure']; ?></td>
                        <td><?php echo $tareoItem['Company']['name']; ?></td>
                        <td><?php echo $tareoItem['Job']['name']; ?></td>
                        <td><?php echo $tareoItem['Location']['name']; ?></td>
                    </tr>
                <?php $i++; } ?>
            </tbody>
        </table>
    <?php } ?>

</div>
