<?php

class reportsComponents extends sfComponents {


    
    /***************************
     * REPORT: People Location *
     ***************************/
    public function executePeopleLocation_form(sfWebRequest $request) {
        $this->form = new peopleLocationForm( array('StartDate' => date('01/m/Y'), 'EndDate' => date('d/m/Y') ) );
        if($request->getParameter($this->form->getName())!="") {
            $this->form->bind($request->getParameter($this->form->getName()));
        }
    }
    public function executePeopleLocation_result(sfWebRequest $request) {
        $this->tareos = array();
        $this->form = new peopleLocationForm();
        if($request->getParameter($this->form->getName())!="") {
            $this->form->bind($request->getParameter($this->form->getName()));
            if ($this->form->isValid()) {
                $this->tareos = peopleLocationQuery::execute($this->form->getValues());
            }
        }
    }
    

    
    /********************
     * REPORT: Trip Log *
     ********************/
    public function executeTripLog_form(sfWebRequest $request) {
        $this->form = new tripLogForm( array('Date'=>date('d/m/Y')) );
        if($request->getParameter($this->form->getName())!="") {
            $this->form->bind($request->getParameter($this->form->getName()));
        }
    }
    public function executeTripLog_result(sfWebRequest $request) {
        $this->trips = array();
        $this->form = new tripLogForm();
        if($request->getParameter($this->form->getName())!="") {
            $this->form->bind($request->getParameter($this->form->getName()));
            if ($this->form->isValid()) {
                $this->trips = tripLogQuery::execute($this->form->getValues());
            }
        }
    }

    

    /*****************************************
     * REPORT: Consolidated Trips by Vehicle *
     *****************************************/
    public function executeConsolidatedTripsByVehicle_form(sfWebRequest $request) {
        $this->form = new consolidatedTripsByVehicleForm( array('StartDate' => date('01/m/Y'), 'EndDate' => date('d/m/Y') ) );
        if($request->getParameter($this->form->getName())!="") {
            $this->form->bind($request->getParameter($this->form->getName()));
        }
    }
    public function executeConsolidatedTripsByVehicle_result(sfWebRequest $request) {
        $this->rows = array();
        $this->data = array();
        $this->sql = '';
        $this->form = new consolidatedTripsByVehicleForm();
        if($request->getParameter($this->form->getName())!="") {
            $this->form->bind($request->getParameter($this->form->getName()));
            if ($this->form->isValid()) {
                list($this->rows,$this->data,$this->sql) = consolidatedTripsByVehicleQuery::execute($this->form->getValues());
            }
        }
    }



    /**************************************************
     * REPORT: Distribution of Cost Center by Company *
     **************************************************/
    public function executeDistributionOfCostCenterByCompany_form(sfWebRequest $request) {
        $this->form = new distributionOfCostCenterByCompanyForm( array('StartDate' => date('01/m/Y'), 'EndDate' => date('d/m/Y') ) );
        if($request->getParameter($this->form->getName())!="") {
            $this->form->bind($request->getParameter($this->form->getName()));
        }
    }
    public function executeDistributionOfCostCenterByCompany_result(sfWebRequest $request) {
        $this->rows = array();
        $this->rows2 = array();
        $this->rows3 = array();
        $this->total = 0;
        $this->companies = array();
        $this->days = array();
        $this->form = new distributionOfCostCenterByCompanyForm();
        if($request->getParameter($this->form->getName())!="") {
            $this->form->bind($request->getParameter($this->form->getName()));
            if ($this->form->isValid()) {
                list(
                        $this->rows,
                        $this->rows2,
                        $this->rows3,
                        $this->total,
                        $this->companies,
                        $this->days
                ) = distributionOfCostCenterByCompanyQuery::execute($this->form->getValues());
            }
        }
    }


    
    /*****************************************************************
     * REPORT: Hours, Cost and Fuel by Cost center, Vehicle and Date *
     *****************************************************************/
    public function executeHoursCostFuelByCostCenterVehicleAndDate_form(sfWebRequest $request) {
        $this->form = new hoursCostFuelByCostCenterVehicleAndDateForm();
        if($request->getParameter($this->form->getName())!="") {
            $this->form->bind($request->getParameter($this->form->getName()));
        }
    }
    public function executeHoursCostFuelByCostCenterVehicleAndDate_result(sfWebRequest $request) {
    }


    
    /***********************************************************
     * REPORT: Consolidated Hours Cost and Fuel by Cost center *
     ***********************************************************/
    public function executeConsolidatedHoursCostAndFuelByCostCenter_form(sfWebRequest $request) {
        $this->form = new consolidatedHoursCostAndFuelByCostCenterForm(array('StartDate' => date('01/m/Y'), 'EndDate' => date('d/m/Y') ));
        if($request->getParameter($this->form->getName())!="") {
            $this->form->bind($request->getParameter($this->form->getName()));
        }
    }
    public function executeConsolidatedHoursCostAndFuelByCostCenter_result(sfWebRequest $request) {
        $this->data = array();
        $this->days = array();
        $this->form = new consolidatedHoursCostAndFuelByCostCenterForm();
        if($request->getParameter($this->form->getName())!="") {
            $this->form->bind($request->getParameter($this->form->getName()));
            if ($this->form->isValid()) {
                list($this->data,$this->days) = consolidatedHoursCostAndFuelByCostCenterQuery::execute($this->form->getValues());
            }
        }
    }



    /*******************************************************
     * REPORT: Accumulated Transported Cargo and Personnel *
     *******************************************************/
    public function executeAccumulatedTransportedCargoAndPersonnel_form(sfWebRequest $request) {
        $this->form = new accumulatedTransportedCargoAndPersonnelForm();
        if($request->getParameter($this->form->getName())!="") {
            $this->form->bind($request->getParameter($this->form->getName()));
        }
    }
    public function executeAccumulatedTransportedCargoAndPersonnel_result(sfWebRequest $request) {
    }



    /********************************************
     * REPORT: Hours,  Cost and Fuel By Company *
     ********************************************/
    public function executeHoursCostFuelCompany_form(sfWebRequest $request) {
        $this->form = new hoursCostFuelCompanyForm();
        if($request->getParameter($this->form->getName())!="") {
            $this->form->bind($request->getParameter($this->form->getName()));
        }
    }
    public function executeHoursCostFuelCompany_result(sfWebRequest $request) {
    }



}
?>
