<?php

/**
 * distributionOfCostCenterByCompanyForm
 */

class distributionOfCostCenterByCompanyForm extends BaseForm {

    protected static $companies;

    public function configure() {

        self::$companies[''] = "[TODAS]";
        foreach (Doctrine::getTable('Company')->findBy('is_active', 1) as $company ) {
            self::$companies[$company->id] = $company->name;
        }
        
        $this->setWidgets(array(
                'Company' => new sfWidgetFormSelect(array('choices' =>self::$companies )),
                'StartDate' => new sfWidgetFormInputText(array(),array('size'=>'10')),
                'EndDate' => new sfWidgetFormInputText(array(),array('size'=>'10'))
        ));

        $valid_companies = array_keys(array_slice(self::$companies,1,count(self::$companies)-1,true));
        
        // Translating to spanish the fields labels
        $this->widgetSchema->setLabels(array(
                'Company'=>'Empresa',
                'StartDate'=>'Fecha inicial',
                'EndDate'=>'Fecha final'
        ));

        // Setting validators to each field
        $this->setValidators(array(
            'Company' => new sfValidatorChoice(
                array( 'required'=>false, 'choices' => $valid_companies ),
                array(
                    'required' => '<u>'.$this->getWidget('Company')->getLabel().'</u>: Debe seleccionar una Empresa',
                    'invalid' => '<u>'.$this->getWidget('Company')->getLabel().'</u>: Inválido'
                )
            ),
            'StartDate' => new sfValidatorDate(
                array(
                    'date_format' => '@(?P<day>\d{2}).(?P<month>\d{2}).(?P<year>\d{4})@ ',
                    'date_output' => 'Y-m-d'
                ),
                array(
                    'required' => '<u>'.$this->getWidget('StartDate')->getLabel().'</u>: Este campo es obligatorio',
                    'invalid' => '<u>'.$this->getWidget('StartDate')->getLabel().'</u>: Fecha Inválida',
                    'bad_format'  => '<u>'.$this->getWidget('StartDate')->getLabel().'</u>: El formato de la fecha es (dd/mm/aaaa)'
                )
            ),
            'EndDate' => new sfValidatorDate(
                array(
                    'date_format' => '@(?P<day>\d{2}).(?P<month>\d{2}).(?P<year>\d{4})@ ',
                    'date_output' => 'Y-m-d'
                ),
                array(
                    'required' => '<u>'.$this->getWidget('EndDate')->getLabel().'</u>: Este campo es obligatorio',
                    'invalid' => '<u>'.$this->getWidget('EndDate')->getLabel().'</u>: Fecha Inválida',
                    'bad_format' => '<u>'.$this->getWidget('EndDate')->getLabel().'</u>: El formato de la fecha es (dd/mm/aaaa)'
                )
            )
        ));

        $this->validatorSchema->setPostValidator(
            new sfValidatorSchemaCompare(
                'StartDate',
                sfValidatorSchemaCompare::LESS_THAN_EQUAL,
                'EndDate',
                array('throw_global_error' => true),
                array('invalid' =>
                    'La <u>'.$this->getWidget('StartDate')->getLabel().'</u> ("%left_field%")'.
                    ' debe ser menor que '.
                    'la <u>'.$this->getWidget('EndDate')->getLabel().'</u> ("%right_field%")'
                )
            )
        );

        $this->widgetSchema->setNameFormat('reportDistributionOfCostCenterByCompany[%s]');

    }


}
?>