<?php


class hoursCostFuelByCostCenterVehicleAndDateForm extends BaseForm {

    protected static $vehicles;
    protected static $costCenters;

    public function configure() {

        self::$vehicles[''] = "[TODOS]";
        foreach (Doctrine::getTable('Vehicle')->findBy('is_active', 1) as $vehicle ) {
            self::$vehicles[$vehicle->id] = $vehicle->model_name."($vehicle->plate)";
        }

        self::$costCenters[''] = "[TODOS]";
        foreach (Doctrine::getTable('CostCenter')->findBy('is_active', 1) as $cc ) {
            self::$costCenters[$cc->id] = $cc->name;
        }

        $this->setWidgets(array(
                'Vehicle' => new sfWidgetFormSelect(array('choices' =>self::$vehicles )),
                'CostCenter' => new sfWidgetFormSelect(array('choices' =>self::$costCenters )),
                'Date' => new sfWidgetFormInputText(array(),array('size'=>'10'))
        ));

        $valid_vehicles = array_keys(array_slice(self::$vehicles,1,count(self::$vehicles)-1,true));
        $valid_costCenters = array_keys(array_slice(self::$costCenters,1,count(self::$costCenters)-1,true));

        // Translating to spanish the fields labels
        $this->widgetSchema->setLabels(array(
                'Vehicle'=>'Vehículo',
                'CostCenter'=>'Centro de Costo',
                'Date'=>'Fecha'
        ));

        // Setting validators to each field
        $this->setValidators(array(
            'Vehicle' => new sfValidatorChoice(
                array(
                    'required'=>false,
                    'choices' => $valid_vehicles
                ),
                array(
                    'invalid' => '<u>'.$this->getWidget('Vehicle')->getLabel().'</u>: Inválido'
                )
            ),
            'CostCenter' => new sfValidatorChoice(
                array(
                    'required'=>false,
                    'choices' => $valid_costCenters
                ),
                array(
                    'invalid' => '<u>'.$this->getWidget('CostCenter')->getLabel().'</u>: Inválido'
                )
            ),
            'Date' => new sfValidatorDate(
                array(
                    'date_format' => '@(?P<day>\d{2}).(?P<month>\d{2}).(?P<year>\d{4})@ ',
                    'date_output' => 'Y-m-d'
                ),
                array(
                    'required' => '<u>'.$this->getWidget('Date')->getLabel().'</u>: Debe seleccionar una Fecha',
                    'invalid' => '<u>'.$this->getWidget('Date')->getLabel().'</u>: Inválida',
                    'bad_format'  => '<u>'.$this->getWidget('Date')->getLabel().'</u>: El formato es (dd/mm/aaaa)'
                )
            )

        ));

        $this->widgetSchema->setNameFormat('reportHoursCostFuelByCostCenterVehicleAndDate[%s]');

    }


}

?>