<?php

class tripLogForm extends BaseForm {

    protected static $vehicles;

    public function configure() {

        self::$vehicles[''] = "--- Seleccione el Vehículo ---";
        foreach (Doctrine::getTable('Vehicle')->findBy('is_active', 1) as $vehicle ) {
            self::$vehicles[$vehicle->id] = $vehicle->model_name."($vehicle->plate)";
        }
        
        $this->setWidgets(array(
                'Vehicle' => new sfWidgetFormSelect(array('choices' =>self::$vehicles )),
                'Date' => new sfWidgetFormInputText(array(),array('size'=>'10'))
        ));

        $valid_vehicles = array_keys(array_slice(self::$vehicles,1,count(self::$vehicles)-1,true));
        
        // Translating to spanish the fields labels
        $this->widgetSchema->setLabels(array(
                'Vehicle'=>'Vehículo',
                'Date'=>'Fecha'
        ));

        // Setting validators to each field
        $this->setValidators(array(
            'Vehicle' => new sfValidatorChoice(
                array( 'choices' => $valid_vehicles ),
                array(
                    'required' => '<u>'.$this->getWidget('Vehicle')->getLabel().'</u>: Debe seleccionar un Vehículo',
                    'invalid' => '<u>'.$this->getWidget('Vehicle')->getLabel().'</u>: Inválido'
                )
            ),
            'Date' => new sfValidatorDate(
                array(
                    'date_format' => '@(?P<day>\d{2}).(?P<month>\d{2}).(?P<year>\d{4})@ ',
                    'date_output' => 'Y-m-d'
                ),
                array(
                    'required' => '<u>'.$this->getWidget('Date')->getLabel().'</u>: Debe seleccionar una fecha',
                    'invalid' => '<u>'.$this->getWidget('Date')->getLabel().'</u>: Inválida',
                    'bad_format'  => '<u>'.$this->getWidget('Date')->getLabel().'</u>: El formato es (dd/mm/aaaa)'
                )
            )

        ));

        $this->widgetSchema->setNameFormat('reportTripLog[%s]');

    }


}
?>