<?php
/* 
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
*/

/**
 * Description of consolidatedTripsByVehicleQuery
 *
 */
class consolidatedTripsByVehicleQuery implements PLMReport {

    static function execute($formValues) {

        $rows = Doctrine_Query::create()
                ->select(
                        'pmd.id,'.
                        'smd.id,'.
                        'cc.id as ccid,'.
                        't.id,'.
                        'sum(smd.minutes) as minutes,'.
                        'cc.name as ccname,'.
                        't.departure_date,'.
                        'v.id as vid,'.
                        'concat(v.model_name,\' \',v.plate) as vname'
                )
                ->from('StretchManifestDetail smd')
                ->innerJoin('smd.PassengerManifestDetail pmd')
                ->innerJoin('pmd.Trip t')
                ->innerJoin('t.Vehicle v')
                ->innerJoin('pmd.CostCenter cc')
                ->where('t.departure_date >= ?', $formValues['StartDate'] )
                ->andWhere('t.departure_date <= ?', $formValues['EndDate'] )
                ->groupBy('t.vehicle_id, pmd.cost_center_id, t.departure_date')
                ;
        

        
        if(!empty($formValues['Vehicle'])) {
            $rows->andWhere('t.vehicle_id = ?', $formValues['Vehicle'] );
        }
        if(!empty($formValues['CostCenter'])) { 
            $rows->andWhere('cc.id = ?', $formValues['CostCenter'] );
        }
        
        
        $data=array();
        $data['vehicles']=array();
        $data['costCenters']=array();
        
        // diference between startDate and endDate
        $ndays = (strtotime($formValues['EndDate']) - strtotime($formValues['StartDate']))/(60*60*24)+1;
        for($i=0;$i<$ndays;$i++){
            $days[date('Y-m-d',strtotime('+'.$i.' day',strtotime($formValues['StartDate'])))] = 0;
        }
        $data['days'] = $days;

        foreach ($rows->fetchArray() as $smd){

            if(!key_exists($smd['vid'], $data['vehicles'])){
                $data['vehicles'][$smd['vid']] = array('name'=>$smd['vname']);
            }
            if(!key_exists($smd['ccid'], $data['costCenters'])){
                $data['costCenters'][$smd['ccid']] = array('name'=>$smd['ccname']);
            }
            
            $data['minutes'][$smd['vid']][$smd['ccid']][$smd['PassengerManifestDetail']['Trip']['departure_date']] = $smd['minutes'];

            // TOTALS:
            //total by days
            $data['days'][$smd['PassengerManifestDetail']['Trip']['departure_date']] += $smd['minutes'];
            
            //total by cc
            if ( is_array($data['costCenters'][$smd['ccid']]) and key_exists('total',$data['costCenters'][$smd['ccid']]) ){
                $data['costCenters'][$smd['ccid']]['total'] += $smd['minutes'];
            }else{
                $data['costCenters'][$smd['ccid']]['total'] = $smd['minutes'];
            }
            
            //total by vehicle
            if ( is_array($data['vehicles'][$smd['vid']]) and key_exists('total',$data['vehicles'][$smd['vid']]) ){
                $data['vehicles'][$smd['vid']]['total'] += $smd['minutes'];
            }else{
                $data['vehicles'][$smd['vid']]['total'] = $smd['minutes'];
            }

        }


        
        return array($rows->fetchArray(),$data,$rows->getSqlQuery());


    }
}
?>
