<?php

define("DESCRIPTION_MAX_LEGTH", 30);

class createTripForm extends BaseForm {

    protected static $vehicles;
    protected static $origins;

    public function configure() {

        self::$vehicles[''] = "--- Seleccione el Vehículo ---";
        foreach (Doctrine::getTable('Vehicle')->findBy('is_active', 1) as $vehicle ) {
            self::$vehicles[$vehicle->id] = $vehicle->model_name."($vehicle->plate)";
        }
        
        self::$origins[''] = "--- Seleccione el Origen ---";
        foreach (Doctrine::getTable('Location')->findBy('is_active', 1) as $origin ) {
            self::$origins[$origin->id] = $origin->name;
        }
        
        $valid_vehicles = array_keys(array_slice(self::$vehicles,1,count(self::$vehicles)-1,true));
        $valid_origins = array_keys(array_slice(self::$origins,1,count(self::$origins)-1,true));


        $this->setWidgets(array(
                'Vehicle' => new sfWidgetFormSelect(array('choices' =>self::$vehicles )),
                'Origin' => new sfWidgetFormSelect(array('choices' =>self::$origins )),
                'Description' => new sfWidgetFormInputText(array(),array('maxlength'=>DESCRIPTION_MAX_LEGTH)),
                'Date' => new sfWidgetFormInputHidden()
        ));

        $this->setValidators(array(
                'Vehicle' => new sfValidatorChoice(
                        array( 'choices' => $valid_vehicles ),
                        array( 'required' => 'Debe seleccionar un Vehículo' )
                ),
                'Origin' => new sfValidatorChoice(
                        array( 'choices' => $valid_origins ),
                        array( 'required' => 'Debe seleccionar un Origen' )
                ),
                'Description' => new sfValidatorString(
                        array(
                            'max_length' => DESCRIPTION_MAX_LEGTH
                        ),
                        array(
                            'required' => 'Debe ingresar una breve descripción',
                            'max_length' => '"%value%" es demasiado largo (Máximo %max_length% caracteres).',
                            'min_length' => '"%value%" es demasiado corto (Mínimo %min_length% caracteres).'
                        )
                ),
                'Date' => new sfValidatorDate()
        ));

        $this->widgetSchema->setLabels(array(
            'Vehicle' => 'Vehículo',
            'Origin' => 'Origen',
            'Description' => 'Descripción'
        ));

        $this->widgetSchema->setNameFormat('createTripForm[%s]');

    }

}
?>