<?php slot('userName',$userName); ?>
<?php
$fligths_given_date = '@fligths_given_date?';
$fligths_given_date .= 'year='.substr($trip->departure_date,0,4).'&';
$fligths_given_date .= 'month='.substr($trip->departure_date,5,2).'&';
$fligths_given_date .= 'day='.substr($trip->departure_date,8,2);

slot('breadCrumbs',Helper::makeBreadCrumbs(array(
        array('link' => url_for('@fligths'), 'text' => 'Viajes'),
        array('link' => url_for($fligths_given_date),'text' => date('d/m/Y', strtotime($trip->departure_date))),
        array('text' => $id)
))); ?>

<?php use_javascript('trip_planning_edit.js') ?>
<?php use_stylesheet('trip_planning_edit.css') ?>

<div id="del_link" style="display: none;"><?=image_tag('delete.gif',array('class'=>'del_link'))?></div>
<input type="hidden" id="idOrigin" value="<?=$trip->Origin->id?>" />

<div id="main">

    <div id="edit_trip_form">
        <h2>Crear viaje</h2>
        <form id="editTrip" method="POST" name="editTrip" action="<?php echo url_for('trip_planning/createStretch?id='.$id); ?>">
            <?=$editTripForm->renderHiddenFields()?>
            <ul class="divided vertical_form">
                <li>
                    <table class="data" border="0" cellspacing="0" cellpadding="0">
                        <tr class="odd">
                            <th>ID de viaje</th>
                            <td><?=$id?></td>
                        </tr>
                        <tr>
                            <th>Vehículo</th>
                            <td><?=$trip->Vehicle->model_name?> (<?=$trip->Vehicle->plate?>)</td>
                        </tr>
                        <tr class="odd">
                            <th>Origen</th>
                            <td id="trip_origin_name"><?=$trip->Origin->name?></td>
                            <input id="trip_origin_id" type="hidden" name="trip_origin_id" value="<?=$trip->Origin->getId()?>" />
                        </tr>
                    </table>
                </li>
                <?php if($editTripForm->hasGlobalErrors()) { ?>
                    <li><?=$editTripForm->renderGlobalErrors()?></li>
                <?php } ?>

                <li>
                    <?=$editTripForm['Description']->renderLabel()?><br />
                    <?=$editTripForm['Description']->renderHelp()?>
                    <?=$editTripForm['Description']->render()?>
                    <?=$editTripForm['Description']->renderError()?>
                </li>
                <li>
                    <?=$editTripForm['EstimatedHour']->renderLabel()?><br />
                    <?=$editTripForm['EstimatedHour']->renderHelp()?>
                    <?=$editTripForm['EstimatedHour']->render()?>
                    <?=$editTripForm['EstimatedHour']->renderError()?>
                </li>
                <li>
                    <?=$editTripForm['EstimatedDuration']->renderLabel()?><br />
                    <?=$editTripForm['EstimatedDuration']->render()?>
                    <?=$editTripForm['EstimatedDuration']->renderHelp()?>
                    <?=$editTripForm['EstimatedDuration']->renderError()?>
                </li>
                <li>
                    <?=$editTripForm['Notes']->renderLabel()?><br />
                    <?=$editTripForm['Notes']->renderHelp()?>
                    <?=$editTripForm['Notes']->render()?>
                    <?=$editTripForm['Notes']->renderError()?>
                </li>
            </ul>
        </form>
    </div>

    <div id="stretch_list">
        <h2>Mangas</h2>
        <ul class="left divided vertical_form">
            <?php if(!$editable) { ?>
                <li>
                    <ul class="warning_list">
                            <?php if($trip->hasTimes()) { ?>
                        <li>Este viaje tiene tiempos registrados en sus mangas</li>
                                <?php } ?>
                            <?php if($trip->hasManifests()) { ?>
                        <li>Este viaje tiene manifiestos registrados en sus mangas</li>
                                <?php } ?>
                            <?php if($trip->isCanceled()) { ?>
                        <li>Este viaje ha sido cancelado</li>
                                <?php } ?>
                    </ul>
                </li>
            <?php } ?>
                <li>
                <?php if($editable) { ?>
                    <form action="" name="addStretchForm">
                        <input type="hidden" name="isEditable" id="isEditable" value="true">
                        <p>
                            <label for="locations">Seleccionar destino:</label><br />
                            <select id="locations" name="locations">
                                <option>---Seleccione destino---</option>
                                <?php foreach ($locations as $location) { ?>
                                    <option value="<?=$location->id?>"><?=$location->name?></option>
                                <?php } ?>
                            </select>
                            <input type="button" id="addStretch" value="Agregar manga">
                        </p>
                    </form>
                <?php }else{ ?>
                    <select id="locations" name="locations" style="display: none;">
                        <?php foreach ($locations as $location) { ?>
                            <option value="<?=$location->id?>"><?=$location->name?></option>
                        <?php } ?>
                    </select>
                <?php } ?>

                <table id="tableStretches" class="data" border="0" cellspacing="0" cellpadding="0">
                    <thead>
                        <tr>
                            <th>Origen</th>
                            <th>Destino</th>
                            <?php if($editable) { ?>
                            <th>Eliminar</th>
                                <?php } ?>
                        </tr>
                    </thead>
                    <?php if($editable) { ?>
                    <tfoot>
                        <tr>
                            <th colspan="3">
                                
                            </th>
                        </tr>
                    </tfoot>
                        <?php } ?>
                    <tbody></tbody>
                </table>



            </li>
            <li>
                <div class="left">
                    <input type="submit" id="submitEditTrip" value="Actualizar viaje" />
                </div>
                <div class="right">
                    <?php echo button_to('Salir', $fligths_given_date) ?>
                </div>
                <div class="clear"></div>
            </li>
        </ul>
    </div>

    <div id="last_column">
        <fieldset class="alert">
            <legend>Anular viaje</legend>
            <p>
                Si cancela este viaje, se perderán los manifiestos y la
                información ingresada por el radio operador
            </p>
            <?php echo button_to('Anular viaje', 'trip_planning/cancelTrip?id='.$trip->id,'confirm=¿Está seguro que desea ANULAR este viaje?') ?>
        </fieldset>
    </div>

</div>
