<?php

/**
 * unavailability actions.
 *
 * @package    PLM
 * @subpackage unavailability
 * @author     Aureal_Systems
 * @version    SVN: $Id: actions.class.php 23810 2009-11-12 11:07:44Z Kris.Wallsmith $
 */
class unavailabilityActions extends sfActions
{
  public function executeIndex(sfWebRequest $request)
  {
    $this->username = $this->getUser()->getUsername();
    $start_date = $request->getParameter('start_date', NULL);
    $end_date = $request->getParameter('end_date', NULL);
    if (is_null($start_date)===false && is_null($end_date)===false) {
       $this->vehicle_unavailabilities = VehicleUnavailabilityTable::getByDateRange($start_date, $end_date);
    } else {
       $this->vehicle_unavailabilities = Doctrine::getTable('VehicleUnavailability')
      ->createQuery('a')
      ->execute();
    }
    $this->form = new VehicleUnavailabilitySearchForm($_GET);
  }

  public function executeNew(sfWebRequest $request)
  {    
    $this->username = $this->getUser()->getUsername();
    $this->form = new VehicleUnavailabilityForm();
  }

  public function executeCreate(sfWebRequest $request)
  {    
    $this->username = $this->getUser()->getUsername();
    $this->forward404Unless($request->isMethod(sfRequest::POST));

    $this->form = new VehicleUnavailabilityForm();

    $this->processForm($request, $this->form);

    $this->setTemplate('new');
  }

  public function executeEdit(sfWebRequest $request)
  {
    $this->username = $this->getUser()->getUsername();
    $this->forward404Unless($vehicle_unavailability = Doctrine::getTable('VehicleUnavailability')->find(array($request->getParameter('id'))), sprintf('Object vehicle_unavailability does not exist (%s).', $request->getParameter('id')));
    $this->form = new VehicleUnavailabilityForm($vehicle_unavailability);
    $this->vehicle_unavailability = $vehicle_unavailability;
  }

  public function executeUpdate(sfWebRequest $request)
  {
    $this->username = $this->getUser()->getUsername();
    $this->forward404Unless($request->isMethod(sfRequest::POST) || $request->isMethod(sfRequest::PUT));
    $this->forward404Unless($vehicle_unavailability = Doctrine::getTable('VehicleUnavailability')->find(array($request->getParameter('id'))), sprintf('Object vehicle_unavailability does not exist (%s).', $request->getParameter('id')));
    $this->form = new VehicleUnavailabilityForm($vehicle_unavailability);

    $this->processForm($request, $this->form);
    $this->vehicle_unavailability = $vehicle_unavailability;
    $this->setTemplate('edit');
  }

  public function executeDelete(sfWebRequest $request)
  {
    $request->checkCSRFProtection();

    $this->forward404Unless($vehicle_unavailability = Doctrine::getTable('VehicleUnavailability')->find(array($request->getParameter('id'))), sprintf('Object vehicle_unavailability does not exist (%s).', $request->getParameter('id')));
    $vehicle_unavailability->delete();

    $this->redirect('@unavailability');
  }

  protected function processForm(sfWebRequest $request, sfForm $form)
  {
    $form->bind($request->getParameter($form->getName()), $request->getFiles($form->getName()));
    if ($form->isValid())
    {
      $vehicle_unavailability = $form->save();
      $this->redirect('@unavailability');
    }
  }
}
