<?php

/**
 * UnavailabilitySearchForm form.
 *
 * @package    sf_sandbox
 * @subpackage form
 * @author     Your name here
 * @version    SVN: $Id: sfDoctrineFormTemplate.php 23810 2009-11-12 11:07:44Z Kris.Wallsmith $
 */
class VehicleUnavailabilitySearchForm extends BaseForm
{
  public function configure() {
    // adding 4 new widgets for date and time pickers
    $this->widgetSchema['aux_start_date'] = new sfWidgetFormInputText(array(),array('size'=>10));
    $this->widgetSchema['aux_end_date'] = new sfWidgetFormInputText(array(),array('size'=>10));
    $this->widgetSchema['aux_start_time'] = new sfWidgetFormInputText(array(),array('size'=>10));
    $this->widgetSchema['aux_end_time'] = new sfWidgetFormInputText(array(),array('size'=>10));
    $this->widgetSchema['start_date'] = new sfWidgetFormInputHidden();
    $this->widgetSchema['end_date'] = new sfWidgetFormInputHidden();

    $this->widgetSchema->setLabels(array(
       'vehicle_id' => 'Vehiculo',
       'aux_start_date' => 'Fecha y hora de inicio',
       'aux_end_date' => 'Fecha y hora de termino',
       'observations'=> 'Observaciones'
    ));
    $this->validatorSchema['start_date'] = new sfValidatorDateTime();
    $this->validatorSchema['end_date'] = new sfValidatorDateTime();

    // adding 4 new validators for date and time pickers
    $this->setValidator('aux_start_date', new sfValidatorDate(
        array(
            'date_format' => '@(?P<day>\d{2})/(?P<month>\d{2})/(?P<year>\d{4})@',
            'date_output' => 'Y-m-d'
        ),
        array(
            'required'=>'Debe ingresar una fecha',
            'invalid'=>'Fecha inválida',
            'bad_format'  => 'El formato de la fecha es (dd/mm/aaaa)'
        )
    ));
    $this->setValidator('aux_end_date', new sfValidatorDate(
        array(
            'date_format' => '@(?P<day>\d{2})/(?P<month>\d{2})/(?P<year>\d{4})@',
            'date_output' => 'Y-m-d'
        ),
        array(
            'required'=>'Debe ingresar una fecha',
            'invalid'=>'Fecha inválida',
            'bad_format'  => 'El formato de la fecha es (dd/mm/aaaa)'
        )
    ));
    $this->setValidator('aux_start_time', new sfValidatorTime(
        array(
            'time_format' => '@(?P<hour>\d{1,2}):(?P<minute>\d{2}) (?P<amp>am|pm)@'
        ),
        array(
            'required'=>'Debe ingresar una hora',
            'invalid'=>'Hora inválida',
            'bad_format'=>'El formato es: "8:30 am"'
        )
    ));
    $this->setValidator('aux_end_time', new sfValidatorTime(
        array(
            'time_format' => '@(?P<hour>\d{1,2}):(?P<minute>\d{2}) (?P<amp>am|pm)@'
        ),
        array(
            'required'=>'Debe ingresar una hora',
            'invalid'=>'Hora inválida',
            'bad_format'=>'El formato es: "8:30 am"'
        )
    ));
    $this->setValidator('start_date', new sfValidatorDateTime(
        array(
            'date_format' =>    '@(?P<day>\d{2})/(?P<month>\d{2})/(?P<year>\d{4}) '.
                                '(?P<hour>\d{1,2}):(?P<minute>\d{2}):(?P<seconds>\d{2})@'
        ),
        array(
            'required'=>'Debe ingresar la hora y fecha de Entrada',
            'invalid'=>'Hora y fecha de Entrada inválida',
            'bad_format'=>'El formato es: "23/02/2010 8:30:00"'
        )
    ));
    $this->setValidator('end_date', new sfValidatorDateTime(
        array(
            'date_format' =>    '@(?P<day>\d{2})/(?P<month>\d{2})/(?P<year>\d{4}) '.
                                '(?P<hour>\d{1,2}):(?P<minute>\d{2}):(?P<seconds>\d{2})@'
        ),
        array(
            'required'=>'Debe ingresar la hora y fecha de Salida',
            'invalid'=>'Hora y fecha de Salida inválida',
            'bad_format'=>'El formato es: "23/02/2010 8:30:00"'
    )));

    $this->validatorSchema->setPostValidator(
        new sfValidatorSchemaCompare(
            'start_date',
            sfValidatorSchemaCompare::LESS_THAN,
            'end_date',
            array('throw_global_error' => true),
            array('invalid' => 'La Entrada ("%left_field%") debe ser antes de la Salida ("%right_field%")')
        )
    );


  }
}
