<?php

/**
 * vehicle actions.
 *
 * @package    PLM
 * @subpackage vehicle
 * @author     Aureal_Systems
 * @version    SVN: $Id: actions.class.php 23810 2009-11-12 11:07:44Z Kris.Wallsmith $
 */
class vehicleActions extends sfActions
{
  public function executeIndex(sfWebRequest $request)
  {
    $this->username = $this->getUser()->getUsername();
    $this->vehicles = Doctrine::getTable('Vehicle')
      ->createQuery('a')
      ->execute();
  }

  public function executeNew(sfWebRequest $request)
  {
    $this->username = $this->getUser()->getUsername();
    $this->form = new VehicleForm();
  }

  public function executeCreate(sfWebRequest $request)
  {
    $this->username = $this->getUser()->getUsername();

    $this->forward404Unless($request->isMethod(sfRequest::POST));

    $this->form = new VehicleForm();

    $this->processForm($request, $this->form);

    $this->setTemplate('new');
  }

  public function executeEdit(sfWebRequest $request)
  { 
    $this->username = $this->getUser()->getUsername();
    $this->forward404Unless($vehicle = Doctrine::getTable('Vehicle')->find(array($request->getParameter('id'))), sprintf('Object vehicle does not exist (%s).', $request->getParameter('id')));
    $this->form = new VehicleForm($vehicle);
    $this->vehicle = $vehicle;
  }

  public function executeUpdate(sfWebRequest $request)
  {
    $this->username = $this->getUser()->getUsername();
    $this->forward404Unless($request->isMethod(sfRequest::POST) || $request->isMethod(sfRequest::PUT));
    $this->forward404Unless($vehicle = Doctrine::getTable('Vehicle')->find(array($request->getParameter('id'))), sprintf('Object vehicle does not exist (%s).', $request->getParameter('id')));
    $this->form = new VehicleForm($vehicle);

    $this->processForm($request, $this->form);
    $this->vehicle = $vehicle;
    $this->setTemplate('edit');
  }

  public function executeDelete(sfWebRequest $request)
  {
    $this->username = $this->getUser()->getUsername();

    $request->checkCSRFProtection();

    $this->forward404Unless($vehicle = Doctrine::getTable('Vehicle')->find(array($request->getParameter('id'))), sprintf('Object vehicle does not exist (%s).', $request->getParameter('id')));
    $vehicle->delete();

    $this->redirect('@vehicle');
  }

  protected function processForm(sfWebRequest $request, sfForm $form)
  {
    $form->bind($request->getParameter($form->getName()), $request->getFiles($form->getName()));
    if ($form->isValid())
    {
      $vehicle = $form->save();

      $this->redirect('@vehicle');
    }
  }
}
