<?php

/**
 * PassengerManifestDetail filter form base class.
 *
 * @package    PLM
 * @subpackage filter
 * @author     Aureal_Systems
 * @version    SVN: $Id: sfDoctrineFormFilterGeneratedTemplate.php 24171 2009-11-19 16:37:50Z Kris.Wallsmith $
 */
abstract class BasePassengerManifestDetailFormFilter extends BaseFormFilterDoctrine
{
  public function setup()
  {
    $this->setWidgets(array(
      'trip_id'                => new sfWidgetFormDoctrineChoice(array('model' => $this->getRelatedModelName('Trip'), 'add_empty' => true)),
      'stretch_origin_id'      => new sfWidgetFormDoctrineChoice(array('model' => $this->getRelatedModelName('Origin'), 'add_empty' => true)),
      'stretch_destination_id' => new sfWidgetFormDoctrineChoice(array('model' => $this->getRelatedModelName('Destination'), 'add_empty' => true)),
      'passenger_id'           => new sfWidgetFormDoctrineChoice(array('model' => $this->getRelatedModelName('Person'), 'add_empty' => true)),
      'weight'                 => new sfWidgetFormFilterInput(array('with_empty' => false)),
      'cost_center_id'         => new sfWidgetFormDoctrineChoice(array('model' => $this->getRelatedModelName('CostCenter'), 'add_empty' => true)),
      'company_id'             => new sfWidgetFormDoctrineChoice(array('model' => $this->getRelatedModelName('Company'), 'add_empty' => true)),
    ));

    $this->setValidators(array(
      'trip_id'                => new sfValidatorDoctrineChoice(array('required' => false, 'model' => $this->getRelatedModelName('Trip'), 'column' => 'id')),
      'stretch_origin_id'      => new sfValidatorDoctrineChoice(array('required' => false, 'model' => $this->getRelatedModelName('Origin'), 'column' => 'id')),
      'stretch_destination_id' => new sfValidatorDoctrineChoice(array('required' => false, 'model' => $this->getRelatedModelName('Destination'), 'column' => 'id')),
      'passenger_id'           => new sfValidatorDoctrineChoice(array('required' => false, 'model' => $this->getRelatedModelName('Person'), 'column' => 'id')),
      'weight'                 => new sfValidatorSchemaFilter('text', new sfValidatorNumber(array('required' => false))),
      'cost_center_id'         => new sfValidatorDoctrineChoice(array('required' => false, 'model' => $this->getRelatedModelName('CostCenter'), 'column' => 'id')),
      'company_id'             => new sfValidatorDoctrineChoice(array('required' => false, 'model' => $this->getRelatedModelName('Company'), 'column' => 'id')),
    ));

    $this->widgetSchema->setNameFormat('passenger_manifest_detail_filters[%s]');

    $this->errorSchema = new sfValidatorErrorSchema($this->validatorSchema);

    $this->setupInheritance();

    parent::setup();
  }

  public function getModelName()
  {
    return 'PassengerManifestDetail';
  }

  public function getFields()
  {
    return array(
      'id'                     => 'Number',
      'trip_id'                => 'ForeignKey',
      'stretch_origin_id'      => 'ForeignKey',
      'stretch_destination_id' => 'ForeignKey',
      'passenger_id'           => 'ForeignKey',
      'weight'                 => 'Number',
      'cost_center_id'         => 'ForeignKey',
      'company_id'             => 'ForeignKey',
    );
  }
}
