<?php

/**
 * Person filter form base class.
 *
 * @package    PLM
 * @subpackage filter
 * @author     Aureal_Systems
 * @version    SVN: $Id: sfDoctrineFormFilterGeneratedTemplate.php 24171 2009-11-19 16:37:50Z Kris.Wallsmith $
 */
abstract class BasePersonFormFilter extends BaseFormFilterDoctrine
{
  public function setup()
  {
    $this->setWidgets(array(
      'doc_type'       => new sfWidgetFormChoice(array('choices' => array('' => '', 'DNI' => 'DNI', 'CE' => 'CE', 'PASAPORTE' => 'PASAPORTE', 'OTRO' => 'OTRO'))),
      'doc_number'     => new sfWidgetFormFilterInput(array('with_empty' => false)),
      'firstname'      => new sfWidgetFormFilterInput(array('with_empty' => false)),
      'last_name'      => new sfWidgetFormFilterInput(array('with_empty' => false)),
      'weight'         => new sfWidgetFormFilterInput(array('with_empty' => false)),
      'company_id'     => new sfWidgetFormDoctrineChoice(array('model' => $this->getRelatedModelName('Company'), 'add_empty' => true)),
      'job_id'         => new sfWidgetFormDoctrineChoice(array('model' => $this->getRelatedModelName('Job'), 'add_empty' => true)),
      'cost_center_id' => new sfWidgetFormDoctrineChoice(array('model' => $this->getRelatedModelName('CostCenter'), 'add_empty' => true)),
      'is_active'      => new sfWidgetFormChoice(array('choices' => array('' => 'yes or no', 1 => 'yes', 0 => 'no'))),
      'created_at'     => new sfWidgetFormFilterDate(array('from_date' => new sfWidgetFormDate(), 'to_date' => new sfWidgetFormDate(), 'with_empty' => false)),
      'updated_at'     => new sfWidgetFormFilterDate(array('from_date' => new sfWidgetFormDate(), 'to_date' => new sfWidgetFormDate(), 'with_empty' => false)),
    ));

    $this->setValidators(array(
      'doc_type'       => new sfValidatorChoice(array('required' => false, 'choices' => array('DNI' => 'DNI', 'CE' => 'CE', 'PASAPORTE' => 'PASAPORTE', 'OTRO' => 'OTRO'))),
      'doc_number'     => new sfValidatorPass(array('required' => false)),
      'firstname'      => new sfValidatorPass(array('required' => false)),
      'last_name'      => new sfValidatorPass(array('required' => false)),
      'weight'         => new sfValidatorSchemaFilter('text', new sfValidatorNumber(array('required' => false))),
      'company_id'     => new sfValidatorDoctrineChoice(array('required' => false, 'model' => $this->getRelatedModelName('Company'), 'column' => 'id')),
      'job_id'         => new sfValidatorDoctrineChoice(array('required' => false, 'model' => $this->getRelatedModelName('Job'), 'column' => 'id')),
      'cost_center_id' => new sfValidatorDoctrineChoice(array('required' => false, 'model' => $this->getRelatedModelName('CostCenter'), 'column' => 'id')),
      'is_active'      => new sfValidatorChoice(array('required' => false, 'choices' => array('', 1, 0))),
      'created_at'     => new sfValidatorDateRange(array('required' => false, 'from_date' => new sfValidatorDateTime(array('required' => false, 'datetime_output' => 'Y-m-d 00:00:00')), 'to_date' => new sfValidatorDateTime(array('required' => false, 'datetime_output' => 'Y-m-d 23:59:59')))),
      'updated_at'     => new sfValidatorDateRange(array('required' => false, 'from_date' => new sfValidatorDateTime(array('required' => false, 'datetime_output' => 'Y-m-d 00:00:00')), 'to_date' => new sfValidatorDateTime(array('required' => false, 'datetime_output' => 'Y-m-d 23:59:59')))),
    ));

    $this->widgetSchema->setNameFormat('person_filters[%s]');

    $this->errorSchema = new sfValidatorErrorSchema($this->validatorSchema);

    $this->setupInheritance();

    parent::setup();
  }

  public function getModelName()
  {
    return 'Person';
  }

  public function getFields()
  {
    return array(
      'id'             => 'Number',
      'doc_type'       => 'Enum',
      'doc_number'     => 'Text',
      'firstname'      => 'Text',
      'last_name'      => 'Text',
      'weight'         => 'Number',
      'company_id'     => 'ForeignKey',
      'job_id'         => 'ForeignKey',
      'cost_center_id' => 'ForeignKey',
      'is_active'      => 'Boolean',
      'created_at'     => 'Date',
      'updated_at'     => 'Date',
    );
  }
}
