<?php

/**
 * Stretch filter form base class.
 *
 * @package    PLM
 * @subpackage filter
 * @author     Aureal_Systems
 * @version    SVN: $Id: sfDoctrineFormFilterGeneratedTemplate.php 24171 2009-11-19 16:37:50Z Kris.Wallsmith $
 */
abstract class BaseStretchFormFilter extends BaseFormFilterDoctrine
{
  public function setup()
  {
    $this->setWidgets(array(
      'trip_id'                => new sfWidgetFormDoctrineChoice(array('model' => $this->getRelatedModelName('Trip'), 'add_empty' => true)),
      'origin_id'              => new sfWidgetFormDoctrineChoice(array('model' => $this->getRelatedModelName('Origin'), 'add_empty' => true)),
      'destination_id'         => new sfWidgetFormDoctrineChoice(array('model' => $this->getRelatedModelName('Destination'), 'add_empty' => true)),
      'description'            => new sfWidgetFormFilterInput(),
      'engine_start_time'      => new sfWidgetFormFilterDate(array('from_date' => new sfWidgetFormDate(), 'to_date' => new sfWidgetFormDate())),
      'takeoff_time'           => new sfWidgetFormFilterDate(array('from_date' => new sfWidgetFormDate(), 'to_date' => new sfWidgetFormDate())),
      'departure_time'         => new sfWidgetFormFilterDate(array('from_date' => new sfWidgetFormDate(), 'to_date' => new sfWidgetFormDate())),
      'arrival_time'           => new sfWidgetFormFilterDate(array('from_date' => new sfWidgetFormDate(), 'to_date' => new sfWidgetFormDate())),
      'landing_time'           => new sfWidgetFormFilterDate(array('from_date' => new sfWidgetFormDate(), 'to_date' => new sfWidgetFormDate())),
      'engine_stop_time'       => new sfWidgetFormFilterDate(array('from_date' => new sfWidgetFormDate(), 'to_date' => new sfWidgetFormDate())),
      'cargo_weight'           => new sfWidgetFormFilterInput(),
      'passenger_weight'       => new sfWidgetFormFilterInput(),
      'passenger_count'        => new sfWidgetFormFilterInput(),
      'fuel_recharge'          => new sfWidgetFormChoice(array('choices' => array('' => 'yes or no', 1 => 'yes', 0 => 'no'))),
      'load_type'              => new sfWidgetFormChoice(array('choices' => array('' => '', 'Carga externa' => 'Carga externa', 'Carga interna' => 'Carga interna', 'Pasajeros' => 'Pasajeros', 'Carga interna y pasajeros' => 'Carga interna y pasajeros', 'Materiales de izaje' => 'Materiales de izaje'))),
      'billable_gallons'       => new sfWidgetFormFilterInput(),
      'non_billable_gallons'   => new sfWidgetFormFilterInput(),
      'iquitos_gallons'        => new sfWidgetFormFilterInput(),
      'billable_time'          => new sfWidgetFormFilterInput(),
      'initial_billable_time'  => new sfWidgetFormFilterInput(array('with_empty' => false)),
      'assigned_billable_time' => new sfWidgetFormFilterInput(array('with_empty' => false)),
      'starting_time'          => new sfWidgetFormFilterDate(array('from_date' => new sfWidgetFormDate(), 'to_date' => new sfWidgetFormDate())),
      'stopping_time'          => new sfWidgetFormFilterDate(array('from_date' => new sfWidgetFormDate(), 'to_date' => new sfWidgetFormDate())),
      'created_at'             => new sfWidgetFormFilterDate(array('from_date' => new sfWidgetFormDate(), 'to_date' => new sfWidgetFormDate(), 'with_empty' => false)),
      'updated_at'             => new sfWidgetFormFilterDate(array('from_date' => new sfWidgetFormDate(), 'to_date' => new sfWidgetFormDate(), 'with_empty' => false)),
    ));

    $this->setValidators(array(
      'trip_id'                => new sfValidatorDoctrineChoice(array('required' => false, 'model' => $this->getRelatedModelName('Trip'), 'column' => 'id')),
      'origin_id'              => new sfValidatorDoctrineChoice(array('required' => false, 'model' => $this->getRelatedModelName('Origin'), 'column' => 'id')),
      'destination_id'         => new sfValidatorDoctrineChoice(array('required' => false, 'model' => $this->getRelatedModelName('Destination'), 'column' => 'id')),
      'description'            => new sfValidatorPass(array('required' => false)),
      'engine_start_time'      => new sfValidatorDateRange(array('required' => false, 'from_date' => new sfValidatorDateTime(array('required' => false, 'datetime_output' => 'Y-m-d 00:00:00')), 'to_date' => new sfValidatorDateTime(array('required' => false, 'datetime_output' => 'Y-m-d 23:59:59')))),
      'takeoff_time'           => new sfValidatorDateRange(array('required' => false, 'from_date' => new sfValidatorDateTime(array('required' => false, 'datetime_output' => 'Y-m-d 00:00:00')), 'to_date' => new sfValidatorDateTime(array('required' => false, 'datetime_output' => 'Y-m-d 23:59:59')))),
      'departure_time'         => new sfValidatorDateRange(array('required' => false, 'from_date' => new sfValidatorDateTime(array('required' => false, 'datetime_output' => 'Y-m-d 00:00:00')), 'to_date' => new sfValidatorDateTime(array('required' => false, 'datetime_output' => 'Y-m-d 23:59:59')))),
      'arrival_time'           => new sfValidatorDateRange(array('required' => false, 'from_date' => new sfValidatorDateTime(array('required' => false, 'datetime_output' => 'Y-m-d 00:00:00')), 'to_date' => new sfValidatorDateTime(array('required' => false, 'datetime_output' => 'Y-m-d 23:59:59')))),
      'landing_time'           => new sfValidatorDateRange(array('required' => false, 'from_date' => new sfValidatorDateTime(array('required' => false, 'datetime_output' => 'Y-m-d 00:00:00')), 'to_date' => new sfValidatorDateTime(array('required' => false, 'datetime_output' => 'Y-m-d 23:59:59')))),
      'engine_stop_time'       => new sfValidatorDateRange(array('required' => false, 'from_date' => new sfValidatorDateTime(array('required' => false, 'datetime_output' => 'Y-m-d 00:00:00')), 'to_date' => new sfValidatorDateTime(array('required' => false, 'datetime_output' => 'Y-m-d 23:59:59')))),
      'cargo_weight'           => new sfValidatorSchemaFilter('text', new sfValidatorNumber(array('required' => false))),
      'passenger_weight'       => new sfValidatorSchemaFilter('text', new sfValidatorNumber(array('required' => false))),
      'passenger_count'        => new sfValidatorSchemaFilter('text', new sfValidatorInteger(array('required' => false))),
      'fuel_recharge'          => new sfValidatorChoice(array('required' => false, 'choices' => array('', 1, 0))),
      'load_type'              => new sfValidatorChoice(array('required' => false, 'choices' => array('Carga externa' => 'Carga externa', 'Carga interna' => 'Carga interna', 'Pasajeros' => 'Pasajeros', 'Carga interna y pasajeros' => 'Carga interna y pasajeros', 'Materiales de izaje' => 'Materiales de izaje'))),
      'billable_gallons'       => new sfValidatorSchemaFilter('text', new sfValidatorNumber(array('required' => false))),
      'non_billable_gallons'   => new sfValidatorSchemaFilter('text', new sfValidatorNumber(array('required' => false))),
      'iquitos_gallons'        => new sfValidatorSchemaFilter('text', new sfValidatorNumber(array('required' => false))),
      'billable_time'          => new sfValidatorSchemaFilter('text', new sfValidatorNumber(array('required' => false))),
      'initial_billable_time'  => new sfValidatorSchemaFilter('text', new sfValidatorInteger(array('required' => false))),
      'assigned_billable_time' => new sfValidatorSchemaFilter('text', new sfValidatorInteger(array('required' => false))),
      'starting_time'          => new sfValidatorDateRange(array('required' => false, 'from_date' => new sfValidatorDateTime(array('required' => false, 'datetime_output' => 'Y-m-d 00:00:00')), 'to_date' => new sfValidatorDateTime(array('required' => false, 'datetime_output' => 'Y-m-d 23:59:59')))),
      'stopping_time'          => new sfValidatorDateRange(array('required' => false, 'from_date' => new sfValidatorDateTime(array('required' => false, 'datetime_output' => 'Y-m-d 00:00:00')), 'to_date' => new sfValidatorDateTime(array('required' => false, 'datetime_output' => 'Y-m-d 23:59:59')))),
      'created_at'             => new sfValidatorDateRange(array('required' => false, 'from_date' => new sfValidatorDateTime(array('required' => false, 'datetime_output' => 'Y-m-d 00:00:00')), 'to_date' => new sfValidatorDateTime(array('required' => false, 'datetime_output' => 'Y-m-d 23:59:59')))),
      'updated_at'             => new sfValidatorDateRange(array('required' => false, 'from_date' => new sfValidatorDateTime(array('required' => false, 'datetime_output' => 'Y-m-d 00:00:00')), 'to_date' => new sfValidatorDateTime(array('required' => false, 'datetime_output' => 'Y-m-d 23:59:59')))),
    ));

    $this->widgetSchema->setNameFormat('stretch_filters[%s]');

    $this->errorSchema = new sfValidatorErrorSchema($this->validatorSchema);

    $this->setupInheritance();

    parent::setup();
  }

  public function getModelName()
  {
    return 'Stretch';
  }

  public function getFields()
  {
    return array(
      'id'                     => 'Number',
      'trip_id'                => 'ForeignKey',
      'origin_id'              => 'ForeignKey',
      'destination_id'         => 'ForeignKey',
      'description'            => 'Text',
      'engine_start_time'      => 'Date',
      'takeoff_time'           => 'Date',
      'departure_time'         => 'Date',
      'arrival_time'           => 'Date',
      'landing_time'           => 'Date',
      'engine_stop_time'       => 'Date',
      'cargo_weight'           => 'Number',
      'passenger_weight'       => 'Number',
      'passenger_count'        => 'Number',
      'fuel_recharge'          => 'Boolean',
      'load_type'              => 'Enum',
      'billable_gallons'       => 'Number',
      'non_billable_gallons'   => 'Number',
      'iquitos_gallons'        => 'Number',
      'billable_time'          => 'Number',
      'initial_billable_time'  => 'Number',
      'assigned_billable_time' => 'Number',
      'starting_time'          => 'Date',
      'stopping_time'          => 'Date',
      'created_at'             => 'Date',
      'updated_at'             => 'Date',
    );
  }
}
