<?php

/**
 * StretchManifestDetail filter form base class.
 *
 * @package    PLM
 * @subpackage filter
 * @author     Aureal_Systems
 * @version    SVN: $Id: sfDoctrineFormFilterGeneratedTemplate.php 24171 2009-11-19 16:37:50Z Kris.Wallsmith $
 */
abstract class BaseStretchManifestDetailFormFilter extends BaseFormFilterDoctrine
{
  public function setup()
  {
    $this->setWidgets(array(
      'stretch_id'                   => new sfWidgetFormDoctrineChoice(array('model' => $this->getRelatedModelName('Stretch'), 'add_empty' => true)),
      'passenger_manifest_detail_id' => new sfWidgetFormDoctrineChoice(array('model' => $this->getRelatedModelName('PassengerManifestDetail'), 'add_empty' => true)),
      'cargo_manifest_detail_id'     => new sfWidgetFormDoctrineChoice(array('model' => $this->getRelatedModelName('CargoManifestDetail'), 'add_empty' => true)),
      'type'                         => new sfWidgetFormChoice(array('choices' => array('' => '', 'passenger' => 'passenger', 'cargo' => 'cargo'))),
      'weight_x_distance'            => new sfWidgetFormFilterInput(array('with_empty' => false)),
      'minutes'                      => new sfWidgetFormFilterInput(array('with_empty' => false)),
      'monetary_value'               => new sfWidgetFormFilterInput(array('with_empty' => false)),
    ));

    $this->setValidators(array(
      'stretch_id'                   => new sfValidatorDoctrineChoice(array('required' => false, 'model' => $this->getRelatedModelName('Stretch'), 'column' => 'id')),
      'passenger_manifest_detail_id' => new sfValidatorDoctrineChoice(array('required' => false, 'model' => $this->getRelatedModelName('PassengerManifestDetail'), 'column' => 'id')),
      'cargo_manifest_detail_id'     => new sfValidatorDoctrineChoice(array('required' => false, 'model' => $this->getRelatedModelName('CargoManifestDetail'), 'column' => 'id')),
      'type'                         => new sfValidatorChoice(array('required' => false, 'choices' => array('passenger' => 'passenger', 'cargo' => 'cargo'))),
      'weight_x_distance'            => new sfValidatorSchemaFilter('text', new sfValidatorNumber(array('required' => false))),
      'minutes'                      => new sfValidatorSchemaFilter('text', new sfValidatorNumber(array('required' => false))),
      'monetary_value'               => new sfValidatorSchemaFilter('text', new sfValidatorNumber(array('required' => false))),
    ));

    $this->widgetSchema->setNameFormat('stretch_manifest_detail_filters[%s]');

    $this->errorSchema = new sfValidatorErrorSchema($this->validatorSchema);

    $this->setupInheritance();

    parent::setup();
  }

  public function getModelName()
  {
    return 'StretchManifestDetail';
  }

  public function getFields()
  {
    return array(
      'id'                           => 'Number',
      'stretch_id'                   => 'ForeignKey',
      'passenger_manifest_detail_id' => 'ForeignKey',
      'cargo_manifest_detail_id'     => 'ForeignKey',
      'type'                         => 'Enum',
      'weight_x_distance'            => 'Number',
      'minutes'                      => 'Number',
      'monetary_value'               => 'Number',
    );
  }
}
