<?php

/**
 * Distance form.
 *
 * @package    PLM
 * @subpackage form
 * @author     Aureal_Systems
 * @version    SVN: $Id: sfDoctrineFormTemplate.php 23810 2009-11-12 11:07:44Z Kris.Wallsmith $
 */
class DistanceForm extends BaseDistanceForm
{
  public function configure()
  {
      $this->offsetUnset('created_at');
      $this->offsetUnset('updated_at');
      $this->widgetSchema->setLabels(array(
          'origin_id'      =>  'Origen',
          'destination_id' =>  'Destino',
          'distance'       =>  'Distancia (Km)'
      ));

      /* validators */
      $this->setValidator('distance', new sfValidatorNumber(
          array(
              'min' => 0
          ),
          array(
              'min'=>'La distancia debe ser igual o mayor que cero.',
              'invalid' => 'Ingresa la distancia en kilómetros como un valor no-negativo',
              'required' => 'Este campo es obligatorio'
          )
      ));

      $this->validatorSchema->setPostValidator(
          new sfValidatorSchemaCompare(
              'origin_id',
              sfValidatorSchemaCompare::LESS_THAN_EQUAL,
              'destination_id',
              array(
                  'throw_global_error' => false
              ),
              array(
                  'invalid' => 'Debe registrar las ubicaciones en el orden inverso'
              )
          )
      );

      $this->mergePostValidator(
          new sfValidatorDoctrineUnique(
              array(
                   'model' => 'Distance', 
                  'column' => array('origin_id', 'destination_id')
              ), 
              array(
                  'invalid'=>'Ya existe una distancia registrada para esta combinación de ubicaciones'
              )
          )
      );
  }

}

?>
