<?php

/**
 * Stretch form base class.
 *
 * @method Stretch getObject() Returns the current form's model object
 *
 * @package    PLM
 * @subpackage form
 * @author     Aureal_Systems
 * @version    SVN: $Id: sfDoctrineFormGeneratedTemplate.php 24171 2009-11-19 16:37:50Z Kris.Wallsmith $
 */
abstract class BaseStretchForm extends BaseFormDoctrine
{
  public function setup()
  {
    $this->setWidgets(array(
      'id'                     => new sfWidgetFormInputHidden(),
      'trip_id'                => new sfWidgetFormDoctrineChoice(array('model' => $this->getRelatedModelName('Trip'), 'add_empty' => true)),
      'origin_id'              => new sfWidgetFormDoctrineChoice(array('model' => $this->getRelatedModelName('Origin'), 'add_empty' => true)),
      'destination_id'         => new sfWidgetFormDoctrineChoice(array('model' => $this->getRelatedModelName('Destination'), 'add_empty' => true)),
      'description'            => new sfWidgetFormInputText(),
      'engine_start_time'      => new sfWidgetFormDateTime(),
      'takeoff_time'           => new sfWidgetFormDateTime(),
      'departure_time'         => new sfWidgetFormDateTime(),
      'arrival_time'           => new sfWidgetFormDateTime(),
      'landing_time'           => new sfWidgetFormDateTime(),
      'engine_stop_time'       => new sfWidgetFormDateTime(),
      'cargo_weight'           => new sfWidgetFormInputText(),
      'passenger_weight'       => new sfWidgetFormInputText(),
      'passenger_count'        => new sfWidgetFormInputText(),
      'fuel_recharge'          => new sfWidgetFormInputCheckbox(),
      'load_type'              => new sfWidgetFormChoice(array('choices' => array('Carga externa' => 'Carga externa', 'Carga interna' => 'Carga interna', 'Pasajeros' => 'Pasajeros', 'Carga interna y pasajeros' => 'Carga interna y pasajeros', 'Materiales de izaje' => 'Materiales de izaje'))),
      'billable_gallons'       => new sfWidgetFormInputText(),
      'non_billable_gallons'   => new sfWidgetFormInputText(),
      'iquitos_gallons'        => new sfWidgetFormInputText(),
      'billable_time'          => new sfWidgetFormInputText(),
      'initial_billable_time'  => new sfWidgetFormInputText(),
      'assigned_billable_time' => new sfWidgetFormInputText(),
      'starting_time'          => new sfWidgetFormDateTime(),
      'stopping_time'          => new sfWidgetFormDateTime(),
      'created_at'             => new sfWidgetFormDateTime(),
      'updated_at'             => new sfWidgetFormDateTime(),
    ));

    $this->setValidators(array(
      'id'                     => new sfValidatorDoctrineChoice(array('model' => $this->getModelName(), 'column' => 'id', 'required' => false)),
      'trip_id'                => new sfValidatorDoctrineChoice(array('model' => $this->getRelatedModelName('Trip'), 'required' => false)),
      'origin_id'              => new sfValidatorDoctrineChoice(array('model' => $this->getRelatedModelName('Origin'), 'required' => false)),
      'destination_id'         => new sfValidatorDoctrineChoice(array('model' => $this->getRelatedModelName('Destination'), 'required' => false)),
      'description'            => new sfValidatorString(array('max_length' => 200, 'required' => false)),
      'engine_start_time'      => new sfValidatorDateTime(array('required' => false)),
      'takeoff_time'           => new sfValidatorDateTime(array('required' => false)),
      'departure_time'         => new sfValidatorDateTime(array('required' => false)),
      'arrival_time'           => new sfValidatorDateTime(array('required' => false)),
      'landing_time'           => new sfValidatorDateTime(array('required' => false)),
      'engine_stop_time'       => new sfValidatorDateTime(array('required' => false)),
      'cargo_weight'           => new sfValidatorNumber(array('required' => false)),
      'passenger_weight'       => new sfValidatorNumber(array('required' => false)),
      'passenger_count'        => new sfValidatorInteger(array('required' => false)),
      'fuel_recharge'          => new sfValidatorBoolean(array('required' => false)),
      'load_type'              => new sfValidatorChoice(array('choices' => array('Carga externa' => 'Carga externa', 'Carga interna' => 'Carga interna', 'Pasajeros' => 'Pasajeros', 'Carga interna y pasajeros' => 'Carga interna y pasajeros', 'Materiales de izaje' => 'Materiales de izaje'), 'required' => false)),
      'billable_gallons'       => new sfValidatorNumber(array('required' => false)),
      'non_billable_gallons'   => new sfValidatorNumber(array('required' => false)),
      'iquitos_gallons'        => new sfValidatorNumber(array('required' => false)),
      'billable_time'          => new sfValidatorNumber(array('required' => false)),
      'initial_billable_time'  => new sfValidatorInteger(array('required' => false)),
      'assigned_billable_time' => new sfValidatorInteger(array('required' => false)),
      'starting_time'          => new sfValidatorDateTime(array('required' => false)),
      'stopping_time'          => new sfValidatorDateTime(array('required' => false)),
      'created_at'             => new sfValidatorDateTime(),
      'updated_at'             => new sfValidatorDateTime(),
    ));

    $this->widgetSchema->setNameFormat('stretch[%s]');

    $this->errorSchema = new sfValidatorErrorSchema($this->validatorSchema);

    $this->setupInheritance();

    parent::setup();
  }

  public function getModelName()
  {
    return 'Stretch';
  }

}
