<?php

/**
 * StretchManifestDetail form base class.
 *
 * @method StretchManifestDetail getObject() Returns the current form's model object
 *
 * @package    PLM
 * @subpackage form
 * @author     Aureal_Systems
 * @version    SVN: $Id: sfDoctrineFormGeneratedTemplate.php 24171 2009-11-19 16:37:50Z Kris.Wallsmith $
 */
abstract class BaseStretchManifestDetailForm extends BaseFormDoctrine
{
  public function setup()
  {
    $this->setWidgets(array(
      'id'                           => new sfWidgetFormInputHidden(),
      'stretch_id'                   => new sfWidgetFormDoctrineChoice(array('model' => $this->getRelatedModelName('Stretch'), 'add_empty' => true)),
      'passenger_manifest_detail_id' => new sfWidgetFormDoctrineChoice(array('model' => $this->getRelatedModelName('PassengerManifestDetail'), 'add_empty' => true)),
      'cargo_manifest_detail_id'     => new sfWidgetFormDoctrineChoice(array('model' => $this->getRelatedModelName('CargoManifestDetail'), 'add_empty' => true)),
      'type'                         => new sfWidgetFormChoice(array('choices' => array('passenger' => 'passenger', 'cargo' => 'cargo'))),
      'weight_x_distance'            => new sfWidgetFormInputText(),
      'minutes'                      => new sfWidgetFormInputText(),
      'monetary_value'               => new sfWidgetFormInputText(),
    ));

    $this->setValidators(array(
      'id'                           => new sfValidatorDoctrineChoice(array('model' => $this->getModelName(), 'column' => 'id', 'required' => false)),
      'stretch_id'                   => new sfValidatorDoctrineChoice(array('model' => $this->getRelatedModelName('Stretch'), 'required' => false)),
      'passenger_manifest_detail_id' => new sfValidatorDoctrineChoice(array('model' => $this->getRelatedModelName('PassengerManifestDetail'), 'required' => false)),
      'cargo_manifest_detail_id'     => new sfValidatorDoctrineChoice(array('model' => $this->getRelatedModelName('CargoManifestDetail'), 'required' => false)),
      'type'                         => new sfValidatorChoice(array('choices' => array('passenger' => 'passenger', 'cargo' => 'cargo'))),
      'weight_x_distance'            => new sfValidatorNumber(array('required' => false)),
      'minutes'                      => new sfValidatorNumber(array('required' => false)),
      'monetary_value'               => new sfValidatorNumber(array('required' => false)),
    ));

    $this->widgetSchema->setNameFormat('stretch_manifest_detail[%s]');

    $this->errorSchema = new sfValidatorErrorSchema($this->validatorSchema);

    $this->setupInheritance();

    parent::setup();
  }

  public function getModelName()
  {
    return 'StretchManifestDetail';
  }

}
