<?php

class DistanceTable extends Doctrine_Table
{
    public static function getDistance($origin_id, $destination_id) {
        if ($origin_id > $destination_id) {
            $aux = $origin_id;
            $origin_id = $destination_id;
            $destination_id = $aux;
            unset($aux);
        }

        $distance = Doctrine_Query::create()
            ->from('Distance d')
            ->where('d.origin_id = ?', $origin_id)
            ->andWhere('d.destination_id = ?', $destination_id)
            ->limit(1)
            ->fetchOne();

        if ($distance) {
            return floatval($distance->getDistance());
        } else {
            return false;
        }

    }    
}
