<?php

class TripTable extends Doctrine_Table {

    /**
     * Retrieves all vehicles with trips with departure in the given date
     * 
     * @param <type> $date
     * @param <type> $category
     * @return <type> 
     */
    static function getVehiclesWithTripsByDate($date, $category = 'Aereo') {
        return Doctrine_Query::create()
                ->from('Vehicle v')
                ->leftJoin("v.Trips t")
                ->where('t.departure_date = ?', $date)
                ->andWhere('v.category = ?', $category)
                ->execute();
    }


    /**
     * Closes the trip planning for a given date
     *
     * @param string $date  Date in database format (yyyy-mm-dd)
     */
    static function closeTripPlanning($date){
        
        $trips_to_close = Doctrine_Query::create()
                ->from('Trip t')
                ->where('t.departure_date = ?', $date)
                ->execute();

        foreach($trips_to_close as $trip_to_close){
            $trip_copy = new ClosedTrip();
            $trip_copy->Trip = $trip_to_close;
            $trip_copy->Vehicle = $trip_to_close->Vehicle;
            $trip_copy->Origin = $trip_to_close->Origin;
            $trip_copy->departure_date = $trip_to_close->departure_date;
            $trip_copy->arrival_date = $trip_to_close->arrival_date;
            $trip_copy->description = $trip_to_close->description;
            $trip_copy->notes = $trip_to_close->notes;
            $trip_copy->estimated_departure = $trip_to_close->estimated_departure;
            $trip_copy->estimated_duration = $trip_to_close->estimated_duration;
            $trip_copy->type = $trip_to_close->type;
            $trip_copy->cost = $trip_to_close->cost;
            $trip_copy->canceled = $trip_to_close->canceled;
            foreach ($trip_to_close->Stretches as $stretch_to_copy) {
                $stretch_copy = new ClosedStretch();
                $stretch_copy->ClosedTrip = $trip_copy;
                $stretch_copy->Stretch = $stretch_to_copy;
                $stretch_copy->Origin = $stretch_to_copy->Origin;
                $stretch_copy->Destination = $stretch_to_copy->Destination;
                $stretch_copy->save();
            }
            $trip_copy->save();
            $trip_to_close->closed = true;
            $trip_to_close->save();
        }

    }

    
    /**
     * return true if any trip for the fiven date has closed flag in true
     * @param <type> $date
     */
    static function isClosedTripPlanning($date){
        
        $is = false;
        
        $trips_to_ask_if_close = Doctrine_Query::create()
                ->from('Trip t')
                ->where('t.departure_date = ?', $date)
                ->execute();

        foreach($trips_to_ask_if_close as $trip_to_ask_if_close){
            if($trip_to_ask_if_close->closed){
                $is = true;
            }
        }
        
        return $is;

    }

    

    
}
