<?php

/**
 * BaseLocation
 * 
 * This class has been auto-generated by the Doctrine ORM Framework
 * 
 * @property string $name
 * @property string $short_name
 * @property boolean $is_active
 * @property Doctrine_Collection $DistancesAsOrigin
 * @property Doctrine_Collection $DistancesAsDestination
 * @property Doctrine_Collection $Trips
 * @property Doctrine_Collection $StretchesAsOrigin
 * @property Doctrine_Collection $StretchesAsDestination
 * @property Doctrine_Collection $Tareos
 * 
 * @method string              getName()                   Returns the current record's "name" value
 * @method string              getShortName()              Returns the current record's "short_name" value
 * @method boolean             getIsActive()               Returns the current record's "is_active" value
 * @method Doctrine_Collection getDistancesAsOrigin()      Returns the current record's "DistancesAsOrigin" collection
 * @method Doctrine_Collection getDistancesAsDestination() Returns the current record's "DistancesAsDestination" collection
 * @method Doctrine_Collection getTrips()                  Returns the current record's "Trips" collection
 * @method Doctrine_Collection getStretchesAsOrigin()      Returns the current record's "StretchesAsOrigin" collection
 * @method Doctrine_Collection getStretchesAsDestination() Returns the current record's "StretchesAsDestination" collection
 * @method Doctrine_Collection getTareos()                 Returns the current record's "Tareos" collection
 * @method Location            setName()                   Sets the current record's "name" value
 * @method Location            setShortName()              Sets the current record's "short_name" value
 * @method Location            setIsActive()               Sets the current record's "is_active" value
 * @method Location            setDistancesAsOrigin()      Sets the current record's "DistancesAsOrigin" collection
 * @method Location            setDistancesAsDestination() Sets the current record's "DistancesAsDestination" collection
 * @method Location            setTrips()                  Sets the current record's "Trips" collection
 * @method Location            setStretchesAsOrigin()      Sets the current record's "StretchesAsOrigin" collection
 * @method Location            setStretchesAsDestination() Sets the current record's "StretchesAsDestination" collection
 * @method Location            setTareos()                 Sets the current record's "Tareos" collection
 * 
 * @package    PLM
 * @subpackage model
 * @author     Aureal_Systems
 * @version    SVN: $Id: Builder.php 6820 2009-11-30 17:27:49Z jwage $
 */
abstract class BaseLocation extends sfDoctrineRecord
{
    public function setTableDefinition()
    {
        $this->setTableName('location');
        $this->hasColumn('name', 'string', 255, array(
             'type' => 'string',
             'notnull' => true,
             'length' => '255',
             ));
        $this->hasColumn('short_name', 'string', 3, array(
             'type' => 'string',
             'notnull' => true,
             'length' => '3',
             ));
        $this->hasColumn('is_active', 'boolean', null, array(
             'type' => 'boolean',
             'notnull' => true,
             'default' => 1,
             ));
    }

    public function setUp()
    {
        parent::setUp();
        $this->hasMany('Distance as DistancesAsOrigin', array(
             'local' => 'id',
             'foreign' => 'origin_id'));

        $this->hasMany('Distance as DistancesAsDestination', array(
             'local' => 'id',
             'foreign' => 'destination_id'));

        $this->hasMany('Trip as Trips', array(
             'local' => 'id',
             'foreign' => 'origin_id'));

        $this->hasMany('Stretch as StretchesAsOrigin', array(
             'local' => 'id',
             'foreign' => 'origin_id'));

        $this->hasMany('Stretch as StretchesAsDestination', array(
             'local' => 'id',
             'foreign' => 'destination_id'));

        $this->hasMany('Tareo as Tareos', array(
             'local' => 'id',
             'foreign' => 'location_id'));

        $timestampable0 = new Doctrine_Template_Timestampable();
        $this->actAs($timestampable0);
    }
}