<?php

/**
 * BaseTareo
 * 
 * This class has been auto-generated by the Doctrine ORM Framework
 * 
 * @property enum $doc_type
 * @property string $doc_number
 * @property string $firstname
 * @property string $last_name
 * @property datetime $arrival
 * @property datetime $departure
 * @property integer $company_id
 * @property integer $job_id
 * @property integer $location_id
 * @property integer $passenger_manifest_detail_id
 * @property Company $Company
 * @property Job $Job
 * @property PassengerManifestDetail $PassengerManifestDetail
 * @property Location $Location
 * 
 * @method enum                    getDocType()                      Returns the current record's "doc_type" value
 * @method string                  getDocNumber()                    Returns the current record's "doc_number" value
 * @method string                  getFirstname()                    Returns the current record's "firstname" value
 * @method string                  getLastName()                     Returns the current record's "last_name" value
 * @method datetime                getArrival()                      Returns the current record's "arrival" value
 * @method datetime                getDeparture()                    Returns the current record's "departure" value
 * @method integer                 getCompanyId()                    Returns the current record's "company_id" value
 * @method integer                 getJobId()                        Returns the current record's "job_id" value
 * @method integer                 getLocationId()                   Returns the current record's "location_id" value
 * @method integer                 getPassengerManifestDetailId()    Returns the current record's "passenger_manifest_detail_id" value
 * @method Company                 getCompany()                      Returns the current record's "Company" value
 * @method Job                     getJob()                          Returns the current record's "Job" value
 * @method PassengerManifestDetail getPassengerManifestDetail()      Returns the current record's "PassengerManifestDetail" value
 * @method Location                getLocation()                     Returns the current record's "Location" value
 * @method Tareo                   setDocType()                      Sets the current record's "doc_type" value
 * @method Tareo                   setDocNumber()                    Sets the current record's "doc_number" value
 * @method Tareo                   setFirstname()                    Sets the current record's "firstname" value
 * @method Tareo                   setLastName()                     Sets the current record's "last_name" value
 * @method Tareo                   setArrival()                      Sets the current record's "arrival" value
 * @method Tareo                   setDeparture()                    Sets the current record's "departure" value
 * @method Tareo                   setCompanyId()                    Sets the current record's "company_id" value
 * @method Tareo                   setJobId()                        Sets the current record's "job_id" value
 * @method Tareo                   setLocationId()                   Sets the current record's "location_id" value
 * @method Tareo                   setPassengerManifestDetailId()    Sets the current record's "passenger_manifest_detail_id" value
 * @method Tareo                   setCompany()                      Sets the current record's "Company" value
 * @method Tareo                   setJob()                          Sets the current record's "Job" value
 * @method Tareo                   setPassengerManifestDetail()      Sets the current record's "PassengerManifestDetail" value
 * @method Tareo                   setLocation()                     Sets the current record's "Location" value
 * 
 * @package    PLM
 * @subpackage model
 * @author     Aureal_Systems
 * @version    SVN: $Id: Builder.php 6820 2009-11-30 17:27:49Z jwage $
 */
abstract class BaseTareo extends sfDoctrineRecord
{
    public function setTableDefinition()
    {
        $this->setTableName('tareo');
        $this->hasColumn('doc_type', 'enum', 9, array(
             'type' => 'enum',
             'length' => 9,
             'values' => 
             array(
              0 => 'DNI',
              1 => 'CE',
              2 => 'PASAPORTE',
              3 => 'OTRO',
             ),
             'default' => 'DNI',
             'notnull' => true,
             ));
        $this->hasColumn('doc_number', 'string', 20, array(
             'type' => 'string',
             'notnull' => true,
             'length' => '20',
             ));
        $this->hasColumn('firstname', 'string', 128, array(
             'type' => 'string',
             'notnull' => true,
             'length' => '128',
             ));
        $this->hasColumn('last_name', 'string', 128, array(
             'type' => 'string',
             'notnull' => true,
             'length' => '128',
             ));
        $this->hasColumn('arrival', 'datetime', null, array(
             'type' => 'datetime',
             'notnull' => true,
             ));
        $this->hasColumn('departure', 'datetime', null, array(
             'type' => 'datetime',
             'notnull' => true,
             ));
        $this->hasColumn('company_id', 'integer', null, array(
             'type' => 'integer',
             ));
        $this->hasColumn('job_id', 'integer', null, array(
             'type' => 'integer',
             ));
        $this->hasColumn('location_id', 'integer', null, array(
             'type' => 'integer',
             'notnull' => true,
             ));
        $this->hasColumn('passenger_manifest_detail_id', 'integer', null, array(
             'type' => 'integer',
             ));
    }

    public function setUp()
    {
        parent::setUp();
        $this->hasOne('Company', array(
             'local' => 'company_id',
             'foreign' => 'id',
             'onDelete' => 'CASCADE'));

        $this->hasOne('Job', array(
             'local' => 'job_id',
             'foreign' => 'id',
             'onDelete' => 'CASCADE'));

        $this->hasOne('PassengerManifestDetail', array(
             'local' => 'passenger_manifest_detail_id',
             'foreign' => 'id',
             'onDelete' => 'CASCADE'));

        $this->hasOne('Location', array(
             'local' => 'location_id',
             'foreign' => 'id',
             'onDelete' => 'CASCADE'));

        $timestampable0 = new Doctrine_Template_Timestampable();
        $this->actAs($timestampable0);
    }
}