<?php

/**
 * BaseTrip
 * 
 * This class has been auto-generated by the Doctrine ORM Framework
 * 
 * @property integer $vehicle_id
 * @property integer $origin_id
 * @property date $departure_date
 * @property date $arrival_date
 * @property string $description
 * @property string $notes
 * @property datetime $estimated_departure
 * @property time $estimated_duration
 * @property enum $type
 * @property decimal $cost
 * @property boolean $canceled
 * @property boolean $closed
 * @property Vehicle $Vehicle
 * @property Location $Origin
 * @property Doctrine_Collection $Copy
 * @property Doctrine_Collection $Stretches
 * @property Doctrine_Collection $CrewpersonManifestDetails
 * @property Doctrine_Collection $PassengerManifestDetailsAsOrigin
 * @property Doctrine_Collection $CargoManifestDetailsAsOrigin
 * 
 * @method integer             getVehicleId()                        Returns the current record's "vehicle_id" value
 * @method integer             getOriginId()                         Returns the current record's "origin_id" value
 * @method date                getDepartureDate()                    Returns the current record's "departure_date" value
 * @method date                getArrivalDate()                      Returns the current record's "arrival_date" value
 * @method string              getDescription()                      Returns the current record's "description" value
 * @method string              getNotes()                            Returns the current record's "notes" value
 * @method datetime            getEstimatedDeparture()               Returns the current record's "estimated_departure" value
 * @method time                getEstimatedDuration()                Returns the current record's "estimated_duration" value
 * @method enum                getType()                             Returns the current record's "type" value
 * @method decimal             getCost()                             Returns the current record's "cost" value
 * @method boolean             getCanceled()                         Returns the current record's "canceled" value
 * @method boolean             getClosed()                           Returns the current record's "closed" value
 * @method Vehicle             getVehicle()                          Returns the current record's "Vehicle" value
 * @method Location            getOrigin()                           Returns the current record's "Origin" value
 * @method Doctrine_Collection getCopy()                             Returns the current record's "Copy" collection
 * @method Doctrine_Collection getStretches()                        Returns the current record's "Stretches" collection
 * @method Doctrine_Collection getCrewpersonManifestDetails()        Returns the current record's "CrewpersonManifestDetails" collection
 * @method Doctrine_Collection getPassengerManifestDetailsAsOrigin() Returns the current record's "PassengerManifestDetailsAsOrigin" collection
 * @method Doctrine_Collection getCargoManifestDetailsAsOrigin()     Returns the current record's "CargoManifestDetailsAsOrigin" collection
 * @method Trip                setVehicleId()                        Sets the current record's "vehicle_id" value
 * @method Trip                setOriginId()                         Sets the current record's "origin_id" value
 * @method Trip                setDepartureDate()                    Sets the current record's "departure_date" value
 * @method Trip                setArrivalDate()                      Sets the current record's "arrival_date" value
 * @method Trip                setDescription()                      Sets the current record's "description" value
 * @method Trip                setNotes()                            Sets the current record's "notes" value
 * @method Trip                setEstimatedDeparture()               Sets the current record's "estimated_departure" value
 * @method Trip                setEstimatedDuration()                Sets the current record's "estimated_duration" value
 * @method Trip                setType()                             Sets the current record's "type" value
 * @method Trip                setCost()                             Sets the current record's "cost" value
 * @method Trip                setCanceled()                         Sets the current record's "canceled" value
 * @method Trip                setClosed()                           Sets the current record's "closed" value
 * @method Trip                setVehicle()                          Sets the current record's "Vehicle" value
 * @method Trip                setOrigin()                           Sets the current record's "Origin" value
 * @method Trip                setCopy()                             Sets the current record's "Copy" collection
 * @method Trip                setStretches()                        Sets the current record's "Stretches" collection
 * @method Trip                setCrewpersonManifestDetails()        Sets the current record's "CrewpersonManifestDetails" collection
 * @method Trip                setPassengerManifestDetailsAsOrigin() Sets the current record's "PassengerManifestDetailsAsOrigin" collection
 * @method Trip                setCargoManifestDetailsAsOrigin()     Sets the current record's "CargoManifestDetailsAsOrigin" collection
 * 
 * @package    PLM
 * @subpackage model
 * @author     Aureal_Systems
 * @version    SVN: $Id: Builder.php 6820 2009-11-30 17:27:49Z jwage $
 */
abstract class BaseTrip extends sfDoctrineRecord
{
    public function setTableDefinition()
    {
        $this->setTableName('trip');
        $this->hasColumn('vehicle_id', 'integer', null, array(
             'type' => 'integer',
             'notnull' => true,
             ));
        $this->hasColumn('origin_id', 'integer', null, array(
             'type' => 'integer',
             'notnull' => true,
             ));
        $this->hasColumn('departure_date', 'date', null, array(
             'type' => 'date',
             'notnull' => true,
             ));
        $this->hasColumn('arrival_date', 'date', null, array(
             'type' => 'date',
             'notnull' => false,
             ));
        $this->hasColumn('description', 'string', 50, array(
             'type' => 'string',
             'notnull' => true,
             'length' => '50',
             ));
        $this->hasColumn('notes', 'string', 250, array(
             'type' => 'string',
             'notnull' => false,
             'length' => '250',
             ));
        $this->hasColumn('estimated_departure', 'datetime', null, array(
             'type' => 'datetime',
             ));
        $this->hasColumn('estimated_duration', 'time', null, array(
             'type' => 'time',
             ));
        $this->hasColumn('type', 'enum', null, array(
             'type' => 'enum',
             'values' => 
             array(
              0 => 'Aereo',
              1 => 'Fluvial',
             ),
             'notnull' => true,
             ));
        $this->hasColumn('cost', 'decimal', null, array(
             'type' => 'decimal',
             'notnull' => false,
             ));
        $this->hasColumn('canceled', 'boolean', null, array(
             'type' => 'boolean',
             'notnull' => true,
             'default' => false,
             ));
        $this->hasColumn('closed', 'boolean', null, array(
             'type' => 'boolean',
             'notnull' => true,
             'default' => false,
             ));
    }

    public function setUp()
    {
        parent::setUp();
        $this->hasOne('Vehicle', array(
             'local' => 'vehicle_id',
             'foreign' => 'id',
             'onDelete' => 'CASCADE'));

        $this->hasOne('Location as Origin', array(
             'local' => 'origin_id',
             'foreign' => 'id',
             'onDelete' => 'CASCADE'));

        $this->hasMany('ClosedTrip as Copy', array(
             'local' => 'id',
             'foreign' => 'trip_id'));

        $this->hasMany('Stretch as Stretches', array(
             'local' => 'id',
             'foreign' => 'trip_id'));

        $this->hasMany('CrewpersonManifestDetail as CrewpersonManifestDetails', array(
             'local' => 'id',
             'foreign' => 'trip_id'));

        $this->hasMany('PassengerManifestDetail as PassengerManifestDetailsAsOrigin', array(
             'local' => 'id',
             'foreign' => 'trip_id'));

        $this->hasMany('CargoManifestDetail as CargoManifestDetailsAsOrigin', array(
             'local' => 'id',
             'foreign' => 'trip_id'));

        $timestampable0 = new Doctrine_Template_Timestampable();
        $this->actAs($timestampable0);
    }
}