function isNumber(n) {
  return !isNaN(parseFloat(n)) && isFinite(n);
}


$(function(){

    $("#date").datepicker({
        dateFormat: 'dd/mm/yy',
        showOn: 'button',
        buttonImage: '/images/cal.png',
        buttonImageOnly: true,
        onSelect: function(dateText) {
            window.location = $('#route2fligths').val()+dateText+'/tiempos/';
        }
    });


    // highlighting time controls
    $('.hora').css({
        'border':'1px #e99 solid'
    });


    // Time typing facilities
    $('.hora').focusout(function(){
        var s = $.trim($(this).val());

        // transformations
        if(s=='h'){
            var d = new Date();
            var dHours = d.getHours()<=9 ? '0'+d.getHours() : d.getHours();
            var dMinutes = d.getMinutes()<=9 ? '0'+d.getMinutes() : d.getMinutes();
            $(this).val( dHours + ':' + dMinutes );
        }else if(s.length && s.indexOf(':') == -1 ){
            if($(this).parent().prev().children().length && $($(this).parent().prev().children()[0]).val()!='' && s.length<=2){
                s = s.length==1?s = '0'+s:s;
                $(this).val($($(this).parent().prev().children()[0]).val().split(':')[0]+':'+s);
            }else if($(this).parent().prev().children().length && $($(this).parent().prev().prev().children()[0]).val()!='' && s.length<=2){
                s = s.length==1?s = '0'+s:s;
                $(this).val($($(this).parent().prev().prev().children()[0]).val().split(':')[0]+':'+s);
            }else{
                while(s.length<4){
                    s = '0'+s;
                }
                $(this).val(s.substr(s.length-4, 2) + ':' + s.substr(s.length-2, 2));
            }
        }


        // validations
        s = $.trim($(this).val());
        if(s.length){
            var s_array = s.split(':');
            if(s_array[0]<0||s_array[0]>23||s_array[1]<0||s_array[1]>59||!isNumber(s_array[0])||!isNumber(s_array[1])){
                $(this).css({'border':'2px red solid'});
            }else{
                $(this).css({'border':'1px #e99 solid'});
            }

        }
        
        
    });
    //preformat the dates
    $("input[class=hora]").each(function(){
         var value =  $(this).val();
    	 var date_re = /^\d+-\d+-\d+ \d+:\d+:\d+$/;
         if (value.match(date_re)){
    	     $(this).val(value.substring(11,16));
    	 }
    });


});
