$(function(){

    $("#searchTareo_Date").add('#tareo_arrival_date').add('#tareo_departure_date').datepicker({
        dateFormat: 'dd/mm/yy',
        showOn: 'both',
        buttonImage: '/images/cal.png',
        buttonImageOnly: true
    });

    $('#tareo_arrival_time').timepickr({
        handle: '#trigger-arrival',
        rangeMin: ['00', '05', '10', '15', '20', '25', '30', '35', '40', '45', '50', '55']

    });
    $('#tareo_departure_time').timepickr({handle: '#trigger-departure',
        rangeMin: ['00', '05', '10', '15', '20', '25', '30', '35', '40', '45', '50', '55']
    });

    $('#tareoForm').submit(function(){

        var arrival_time = $.trim($('#tareo_arrival_time').val());
        if (arrival_time.match(/(\d{1,2}):(\d{2}) (am|pm)/)){
            arrival_time = arrival_time.split(' ');
            var arrival_hour_minute = arrival_time[0].split(':');
            var arrival_am_pm = arrival_time[1];
            var arrival_hour = arrival_hour_minute[0];
            var arrival_minute = arrival_hour_minute[1];
            arrival_hour = arrival_am_pm=='pm'?(parseInt(arrival_hour)+12)%24:arrival_hour;
            $('#tareo_arrival').val($('#tareo_arrival_date').val()+' '+arrival_hour+':'+arrival_minute+':00');
        }
        
        var departure_time = $.trim($('#tareo_departure_time').val());
        if (departure_time.match(/(\d{1,2}):(\d{2}) (am|pm)/)){
            departure_time = departure_time.split(' ');
            var departure_hour_minute = departure_time[0].split(':');
            var departure_am_pm = departure_time[1];
            var departure_hour = departure_hour_minute[0];
            var departure_minute = departure_hour_minute[1];
            departure_hour = departure_am_pm=='pm'?(parseInt(departure_hour)+12)%24:departure_hour;
            $('#tareo_departure').val($('#tareo_departure_date').val()+' '+departure_hour+':'+departure_minute+':00');
        }

    });

});