$(function(){

    /**
     * rendering stretches table
     */
    var $stretches = $('#createTripForm_Stretches');
    var $tableStretches = $('#tableStretches tbody');
    var $locations = $('#locations');
    var isEditable = $('#isEditable').val()==='true'?true:false;
    if($stretches.val()!=''){
        var arrS = $stretches.val().split(',');
        for(var i=0;i<arrS.length;i++){
            var lastTD = isEditable?'<td class="del_td"></td>':'';
            var row =
                '<tr class="'+ (i%2==0?'odd':'') + (i==arrS.length-1?' last':'') +'">' +
                    '<td>' +
                        (i==0?$('#trip_origin_name').text():$locations.find('option[value="'+arrS[i-1]+'"]').text()) +
                    '</td>' +
                    '<td class="destiny">' +
                        '<span>'+$locations.find('option[value="'+arrS[i]+'"]').text()+'</span>' +
                        '<input type="hidden" value="'+arrS[i]+'">' +
                    '</td>' +
                    lastTD +
                '</tr>';
            $tableStretches.append(row);
            
        }
    }
    

    $('#addStretch').click(function(){

        $('.del_td .del_link').remove();

        var loc_name = $('#locations option[value="'+$('#locations').val()+'"]').text();
        var $hiddenStretches = $('#createTripForm_Stretches');
        var $new_stretch = $('<tr>');
        var last_loc; // name of last destiny or (if empty) origin of trip
        var class_zebra; // odd or even
        var trip_origin_id = $('#trip_origin_id').val();
        var previous_loc_id;
        var last_loc_id = $('#locations').val();
        var distance_check;
        var error_msg;

        if (!$hiddenStretches.val().length) {
            previous_loc_id = trip_origin_id;
        } else {
            loc_id_array = $hiddenStretches.val().split(',');
            previous_loc_id = loc_id_array[loc_id_array.length-1];
        }

        //alert('Hay que buscar si existe una distencia para ' + previous_loc_id + ' y ' + last_loc_id);


        if (!$('#tableStretches tbody').children().length) { // If stretches table is empty
            class_zebra = 'even';
            last_loc = $('#trip_origin_name').text();
            distance_check = true;
            if (!distance_check) {
                alert('La distancia entre ' + last_loc + ' y ' + loc_name + ' no se encuentra registrada en el sistema.');
                return false;
            }
            $hiddenStretches.val($('#locations').val());
        } else { // if stretches table has rows
            var $last_row = $('#tableStretches tbody tr.last');
            last_loc = $last_row.find('.destiny').text();
            distance_check = true;
            if (!distance_check) {
                alert('La distancia entre ' + last_loc + ' y ' + loc_name + ' no se encuentra registrada en el sistema.');
                return false;
            }
            class_zebra = $last_row.hasClass('odd')?'even':'odd';
            $last_row.removeClass('last');
            $hiddenStretches.val($hiddenStretches.val()+','+$('#locations').val());
        }  

        $new_stretch.addClass(class_zebra);
        $new_stretch.addClass('last');
        $new_stretch.append($('<td>').text(last_loc));
        $new_stretch.append($('<td>').text(loc_name).addClass('destiny'));
        $new_stretch.append($('<td>').append($('#del_link').html()).addClass('del_td'));
        $('#tableStretches tbody').append($new_stretch);

    });

    $('#tableStretches tbody tr.last').children('.del_td').append($('#del_link').html());


    /*
     * Remove the entire <tr> when click on delete link
     */
    $('.del_link').live('click',function(){
        // If there are more than one row
        // then put the 'last' class and the link to previous row
        if($('#tableStretches tbody').children().length>1){
            $(this).parent().parent().prev()
                .addClass('last')
                .children('.del_td')
                .append($('#del_link').html());
        }
        $(this).parent().parent().remove();

        // popping out the las element in the stretches hidden field.
        var arrayStretches = $('#createTripForm_Stretches').val().split(',');
        arrayStretches.pop();
        $('#createTripForm_Stretches').val(arrayStretches.join(','));

    });


    /*
     * Before submit the form, prepend the origin in createTripForm_Stretches
     * and cleaning some fields
     */    
    $('#editTrip').submit(function(){
        // Trimming estimated duration field
        $('#createTripForm_EstimatedDuration').val( $.trim( $('#createTripForm_EstimatedDuration').val() ) );
    });
    

    // When click submitEditTrip button, then submit editTrip Form
    // In the layout, the submit button y outside the form
    $('#submitEditTrip').click(function(){
        $('#editTrip').submit();
    });
    


});
